// Copyleft Sanmayce, 2012 Dec 08.
// Tchutchelo.c, revision 2+.

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define _WIN32_ENVIRONMENT_
//#define _POSIX_ENVIRONMENT_

#define MaxLineLength 960

#ifndef NULL
#ifdef __cplusplus
#define NULL 0
#else
#define NULL ((void*)0)
#endif
#endif

#ifndef FALSE
#define FALSE 0
#endif
#ifndef TRUE
#define TRUE 1
#endif

#ifndef false
#define false 0
#endif
#ifndef true
#define true 1
#endif

#if defined(_WIN32_ENVIRONMENT_)
#include <io.h> // needed for Windows' 'lseeki64' and 'telli64'
//Above line must be commented in order to compile with Intel C compiler: an error "can't find io.h" occurs.
#else
#endif /* defined(_WIN32_ENVIRONMENT_)  */

typedef unsigned char char_t;
typedef char_t *string;
char TAGfree[8] = "*@#^$|%";
typedef unsigned char boolean;
FILE *fp_outLOG;

#define KAZE_tolower(c) ( (((c) >= 'A') && ((c) <= 'Z')) ? ((c) - 'A' + 'a') : (c) )
#define KAZE_toupper(c) ( (((c) >= 'a') && ((c) <= 'z')) ? ((c) - 'a' + 'A') : (c) )

long maskGLOBALlen; // for speed up ((12415s - 755s)/755)*100% = 1544%
long nameGLOBALlen; 

long VIVA_IgorPavlov_invocations_global_counter = 0;
long WildGLOBALhits = 0, TotalLinesENC = 0;


void * memchrKAZE (
        const void * buf,
        const void * chr,
        unsigned long cnt
        )
{
        while ( cnt && (*(unsigned char *)buf != *(unsigned char*)chr) ) {
                buf = (unsigned char *)buf + 1;
                cnt--;
        }

        return(cnt ? (void *)buf : NULL);
}
//Exit:
//       returns pointer to first occurence of chr in buf
//       returns NULL if chr not found in the first cnt bytes


long KAZE_strlen (
        const char * str
        )
{
        const char *eos = str;

        while( *eos++ ) ;

        return( (int)(eos - str - 1) );
}
//_KAZE_strlen PROC NEAR
//; Line 225: const char *eos = str;
//        mov     ecx, DWORD PTR _str$[esp-4]
//        mov     eax, ecx
//$L725:
//; Line 227: while( *eos++ ) ;
//        mov     dl, BYTE PTR [eax]
//        inc     eax
//        test    dl, dl
//        jne     SHORT $L725
//; Line 229: return( (int)(eos - str - 1) );
//        sub     eax, ecx
//        dec     eax
//; Line 230
//        ret     0
//_KAZE_strlen ENDP


long KAZE_strlenLF (
        const char * str
        )
{
        const char *eos = str;
        char LFa[1];
        LFa[0] = 10; //BUG UNcrushed yet: for Windows 13 for POSIX 10
        while( *eos++ != LFa[0] ) ;

        return( (int)(eos - str - 1) );
}

// Kaze [

//       wildcard '*' any character(s) or empty,
//       wildcard '@'/'#' any character {or empty}/{and not empty},
//       wildcard '^'/'$' any ALPHA character {or empty}/{and not empty},
//       wildcard '|'/'%' any NON-ALPHA character {or empty}/{and not empty},
//       wildcard '+'/'~' any WORD {or empty}/{and not empty}.

// wildcard '*' any character(s) or empty,
// wildcard '@' any character or empty,
// wildcard '#' any character and not empty,
// wildcard '$' any ALPHA character and not empty,
// wildcard '%' any NON-ALPHA character and not empty.
// Note: Due to different line endings(CRLF in Windows; LF in UNIX)
//       you must add a '@' wildcard in place of CR: for example in
//       case of searching for '*.pdf' write '*.pdf@'.
// Pattern example: *%%take@%%$$@

static boolean EnhancedMaskTest_OrEmpty_AndNotEmpty(const char *mask, int maskPos, 
                                                 const char *name, int namePos)
{
  char maskChar;
  char c;
  //int maskLen = KAZE_strlen(mask) - maskPos;
  //int nameLen = KAZE_strlenLF(name) - namePos;
  // Above 2 lines are modified with GLOBAL variables for speed as follows:
  int maskLen = maskGLOBALlen - maskPos; // for speed up ((12415s - 755s)/755)*100% = 1544%
  int nameLen = nameGLOBALlen - namePos;
  if (maskLen == 0)
    if (nameLen == 0)
      return true;
    else
      return false;
  maskChar = mask[maskPos];
  if (maskChar == '@') // or empty    
  {
    /*
    if (EnhancedMaskTest_OrEmpty_AndNotEmpty(mask, maskPos + 1, name, namePos)) 
      return true;
    */
    if (EnhancedMaskTest_OrEmpty_AndNotEmpty(mask, maskPos + 1, name, namePos)) // KAZE: THIS LINE DECIDES whether 'or empty' or 'and not empty'
      return true;                                                  //       uncommented is 'or empty'
    if (nameLen == 0) 
      return false;
    return EnhancedMaskTest_OrEmpty_AndNotEmpty(mask,  maskPos + 1, name, namePos + 1);
  }
  else if(maskChar == '#') // and not empty
  {
    /*
    if (EnhancedMaskTest_OrEmpty_AndNotEmpty(mask, maskPos + 1, name, namePos)) 
      return true;
    */
    if (nameLen == 0) 
      return false;
    return EnhancedMaskTest_OrEmpty_AndNotEmpty(mask,  maskPos + 1, name, namePos + 1);
  }
//       wildcard '|'/'%' any NON-ALPHA character {or empty}/{and not empty},
  else if(maskChar == '|') // or empty AND NOT ALPHA
  {

    if (EnhancedMaskTest_OrEmpty_AndNotEmpty(mask, maskPos + 1, name, namePos)) 
      return true;

    c = name[namePos]; 
      if ( (KAZE_toupper(c) >= 'A') && (KAZE_toupper(c) <= 'Z') ) // Stupidly slow: make it faster ...
        return false;

    if (nameLen == 0)
      return false;
    return EnhancedMaskTest_OrEmpty_AndNotEmpty(mask,  maskPos + 1, name, namePos + 1);
  }
  else if(maskChar == '%') // and not empty AND NOT ALPHA
  {
    /*
    if (EnhancedMaskTest_OrEmpty_AndNotEmpty(mask, maskPos + 1, name, namePos)) 
      return true;
    */

    c = name[namePos]; 
      if ( (KAZE_toupper(c) >= 'A') && (KAZE_toupper(c) <= 'Z') ) // Stupidly slow: make it faster ...
        return false;

    if (nameLen == 0)
      return false;
    return EnhancedMaskTest_OrEmpty_AndNotEmpty(mask,  maskPos + 1, name, namePos + 1);
  }
//       wildcard '^'/'$' any ALPHA character {or empty}/{and not empty},
  else if(maskChar == '^') // or empty AND ALPHA
  {

    if (EnhancedMaskTest_OrEmpty_AndNotEmpty(mask, maskPos + 1, name, namePos)) 
      return true;

    c = name[namePos]; 
      if ( (KAZE_toupper(c) < 'A') || (KAZE_toupper(c) > 'Z') ) // Stupidly slow: make it faster ...
        return false;

    if (nameLen == 0)
      return false;
    return EnhancedMaskTest_OrEmpty_AndNotEmpty(mask,  maskPos + 1, name, namePos + 1);
  }
  else if(maskChar == '$') // and not empty AND ALPHA
  {
    /*
    if (EnhancedMaskTest_OrEmpty_AndNotEmpty(mask, maskPos + 1, name, namePos)) 
      return true;
    */

    c = name[namePos]; 
      if ( (KAZE_toupper(c) < 'A') || (KAZE_toupper(c) > 'Z') ) // Stupidly slow: make it faster ...
        return false;

    if (nameLen == 0)
      return false;
    return EnhancedMaskTest_OrEmpty_AndNotEmpty(mask,  maskPos + 1, name, namePos + 1);
  }
  else if(maskChar == '*')
  {
    if (EnhancedMaskTest_OrEmpty_AndNotEmpty(mask, maskPos + 1, name, namePos))
      return true;
    if (nameLen == 0) 
      return false;
    return EnhancedMaskTest_OrEmpty_AndNotEmpty(mask, maskPos, name, namePos + 1);
  }
  else
  {
    c = name[namePos];
    //if (maskChar != c)
      if (KAZE_toupper(maskChar) != KAZE_toupper(c))
        return false;
    return EnhancedMaskTest_OrEmpty_AndNotEmpty(mask,  maskPos + 1, name, namePos + 1);
  }
}


boolean CompareWildCardWithName(const char *mask, const char *name)
{
  boolean Txpbool;
  VIVA_IgorPavlov_invocations_global_counter++;

  maskGLOBALlen = KAZE_strlen(mask);
  nameGLOBALlen = KAZE_strlen(name);

  Txpbool = EnhancedMaskTest_OrEmpty_AndNotEmpty(mask, 0, name, 0);
  if (Txpbool) WildGLOBALhits++;
  return Txpbool;
}
// Above fragment(modified) is from wildcard.cpp from 7zip package.


unsigned long Blunderbuss(char *y, char *x, long n, int m)
   {
int Cycle;
unsigned long hits = 0;
long ThunderwithL = 0, ThunderwithR = 0;
int OneFailureCanRuinYou;

    if ( n == 0 ) return(0);
    for (;;) {

  //Search area is between y[0] .. y[n-1]
    while (y[ThunderwithR] != 10) {++ThunderwithR;} // Works both on UNIX(LF) and Windows(CRLF)
    while (ThunderwithL != 0 && y[--ThunderwithL] != 10) {}
    if (ThunderwithL != 0) ThunderwithL++;
    TotalLinesENC++;

 // To avoid nasty big delays(hours sometime) length of searched line must be limited:
 // recursive function is very heavy then!
 // Something like LBL960 in memory.

OneFailureCanRuinYou = 0; // Presumption for flushing.

 if (ThunderwithR - ThunderwithL <= 960) {
                                         }
                                         else
 OneFailureCanRuinYou = 1; // Presumption for NOT flushing.

if (OneFailureCanRuinYou == 0)
{
          if ( CompareWildCardWithName ( x, &y[ThunderwithL] ) )
          { //if ( memchrKAZE(&y[ThunderwithL], &TAGfree[0], ThunderwithR - ThunderwithL) == NULL && memchrKAZE(&y[ThunderwithL], &TAGfree[1], ThunderwithR - ThunderwithL) == NULL )
            { hits++; 
              /*
              for( Cycle = 0; Cycle < ThunderwithR - ThunderwithL + 1; Cycle++ )
              putchar( y[ThunderwithL + Cycle]);
              */
              //putchar( '\n');
              fwrite( &y[ThunderwithL], ThunderwithR - ThunderwithL + 1, 1, fp_outLOG );
            }
          } // Wildcard if
}
    ThunderwithL = ++ThunderwithR;
    if ( ThunderwithR >= n - 1 ) return(hits);

    } // for (;;)
   }


void x64toaKAZE (      /* stdcall is faster and smaller... Might as well use it for the helper. */
        unsigned long long val,
        char *buf,
        unsigned radix,
        int is_neg
        )
{
        char *p;                /* pointer to traverse string */
        char *firstdig;         /* pointer to first digit */
        char temp;              /* temp char */
        unsigned digval;        /* value of digit */

        p = buf;

        if ( is_neg )
        {
            *p++ = '-';         /* negative, so output '-' and negate */
            val = (unsigned long long)(-(long long)val);
        }

        firstdig = p;           /* save pointer to first digit */

        do {
            digval = (unsigned) (val % radix);
            val /= radix;       /* get next digit */

            /* convert to ascii and store */
            if (digval > 9)
                *p++ = (char) (digval - 10 + 'a');  /* a letter */
            else
                *p++ = (char) (digval + '0');       /* a digit */
        } while (val > 0);

        /* We now have the digit of the number in the buffer, but in reverse
           order.  Thus we reverse them now. */

        *p-- = '\0';            /* terminate string; p points to last digit */

        do {
            temp = *p;
            *p = *firstdig;
            *firstdig = temp;   /* swap *p and *firstdig */
            --p;
            ++firstdig;         /* advance to next two digits */
        } while (firstdig < p); /* repeat until halfway */
}

/* Actual functions just call conversion helper with neg flag set correctly,
   and return pointer to buffer. */

char * _i64toaKAZE (
        long long val,
        char *buf,
        int radix
        )
{
        x64toaKAZE((unsigned long long)val, buf, radix, (radix == 10 && val < 0));
        return buf;
}

char * _ui64toaKAZE (
        unsigned long long val,
        char *buf,
        int radix
        )
{
        x64toaKAZE(val, buf, radix, 0);
        return buf;
}

char * _ui64toaKAZEzerocomma (
        unsigned long long val,
        char *buf,
        int radix
        )
{
                        char *p;
                        char temp;
                        int txpman;
                        int pxnman;
        x64toaKAZE(val, buf, radix, 0);
                        p = buf;
                        do {
                        } while (*++p != '\0');
                        p--; // p points to last digit
                             // buf points to first digit
                        buf[26] = 0;
                        txpman = 1;
                        pxnman = 0;
                        do
                        { if (buf <= p)
                          { temp = *p;
                            buf[26-txpman] = temp; pxnman++;
                            p--;
                            if (pxnman % 3 == 0)
                            { txpman++;
                              buf[26-txpman] = (char) (',');
                            }
                          }
                          else
                          { buf[26-txpman] = (char) ('0'); pxnman++;
                            if (pxnman % 3 == 0)
                            { txpman++;
                              buf[26-txpman] = (char) (',');
                            }
                          }
                          txpman++;
                        } while (txpman <= 26);
        return buf;
}

char * _ui64toaKAZEcomma (
        unsigned long long val,
        char *buf,
        int radix
        )
{
                        char *p;
                        char temp;
                        int txpman;
                        int pxnman;
        x64toaKAZE(val, buf, radix, 0);
                        p = buf;
                        do {
                        } while (*++p != '\0');
                        p--; // p points to last digit
                             // buf points to first digit
                        buf[26] = 0;
                        txpman = 1;
                        pxnman = 0;
                        while (buf <= p)
                        { temp = *p;
                          buf[26-txpman] = temp; pxnman++;
                          p--;
                          if (pxnman % 3 == 0 && buf <= p)
                          { txpman++;
                            buf[26-txpman] = (char) (',');
                          }
                          txpman++;
                        } 
        return buf+26-(txpman-1);
}

int main( int argc, char *argv[])
  {
FILE *fp_in;
FILE *fp_in2;
FILE *fp_in3;
FILE *fp_inLINE;
FILE *fp_outLINE;

      time_t t1, t2, t3;
      char workK[1024*128];
      long workKoffset = -1;

unsigned long LongestLine;
unsigned long ShortestLine;
unsigned long DumpedLines=0;
unsigned long DumpedLinesOLD=0;

unsigned long long FilesLEN;
unsigned long k, k2, k3, LINE10len, LINE10len2, wrdlen;
unsigned long long NumberOfLines;
unsigned long size_in, size_in2;

#if defined(_WIN32_ENVIRONMENT_)
      unsigned long long size_inLINESIXFOUR;
#else
      size_t size_inLINESIXFOUR;
#endif /* defined(_WIN32_ENVIRONMENT_)  */

char LINE10[257]; // 000..255, 256 = 0
char LINE10_2[257];
char wrd[MaxLineLength+1+1]; // crlf
char workbyte;

unsigned long long int i, j;
char llTOaDigits[27]; // 9,223,372,036,854,775,807: 1(sign or carry)+19(digits)+1('\0')+6(,)

char SkipNextSubStagesFlag=0;

printf("Tchutchelo, revision 2+, written by Kaze.\n");
printf("Purpose1: Reports number of lines(LFs) in files from a given filelist.\n");
printf("Purpose2: Dumps to 'Tchutchelo.txt' all lines (<=%d) matching wildcarded line(S) stored in 'Tchutchelo.ini'.\n", MaxLineLength);
printf("Usage: Tchutchelo.exe AllTXTfiles.lst [/suggest|/xgram]\n");
printf("Example:\n");
printf("D:\\>dir *.txt/s/b>AllTXTfiles.lst\n");
printf("D:\\>copy con Tchutchelo.ini\n");
printf("*dog|\n");
printf("F6\n");
printf("D:\\>Tchutchelo.exe AllTXTfiles.lst\n");
printf("Note1: Seven wildcards are available:\n");
printf("       wildcard '*' any character(s) or empty,\n");
printf("       wildcard '@'/'#' any character {or empty}/{and not empty},\n");
printf("       wildcard '^'/'$' any ALPHA character {or empty}/{and not empty},\n");
printf("       wildcard '|'/'%%' any NON-ALPHA character {or empty}/{and not empty}.\n");
printf("Note2: Due to different line endings(CRLF in Windows; LF in UNIX)\n");
printf("       you must add a '|' wildcard in place of CR:\n");
printf("       for example in case of searching for '*.pdf' write '*.pdf|'.\n");
printf("Note3: A pseudo bug exists uncrushed - End-Of-File must be LF character.\n");
printf("Note4: Files can exceed 4GB limit.\n");
printf("Note5: Optional /suggest uses 'Tchutchelo_converted.ini' ('Tchutchelo.ini' converted transparently).\n");
printf("Note6: Optional /xgram uses 'Tchutchelo_converted.ini' ('Tchutchelo.ini' converted transparently).\n");
printf("Note7: When option /suggest is used then 'Tchutchelo.ini' should be wildcardless.\n");
printf("Note8: When option /xgram is used then 'Tchutchelo.ini' should be wildcardless.\n");

if (argc == 1) exit (1);
if (argc > 3) exit (2);

(void) time(&t1);

if( ( fp_in = fopen( argv[1], "rb" ) ) == NULL )
{ printf( "Tchutchelo: Can't open %s file.\n", argv[1] ); return( 1 ); }

if( ( fp_outLOG = fopen( "Tchutchelo.txt", "wb" ) ) == NULL )
{ printf( "Tchutchelo: Can't open Tchutchelo.txt file.\n" ); return( 1 ); }

if( ( fp_in2 = fopen( "Tchutchelo.ini", "rb" ) ) == NULL )
{ printf( "Tchutchelo: Can't open Tchutchelo.ini file.\n" ); return( 1 ); }

fseek( fp_in2, 0L, SEEK_END );
size_in2 = ftell( fp_in2 );
fseek( fp_in2, 0L, SEEK_SET );

if ( argc == 3 && strcmp("/xgram\0",argv[2]) == 0 ) {
// Creating all patterns for xgram matching (((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((
if( ( fp_in3 = fopen( "Tchutchelo_converted.ini", "wb" ) ) == NULL )
{ printf( "Tchutchelo: Can't open Tchutchelo_converted.ini file.\n" ); return( 1 ); }

printf( "Creating 'Tchutchelo_converted.ini' file ...\n" ); 
LINE10len2 = 0;
fseek( fp_in2, 0L, SEEK_SET );
        for( k2 = 0; k2 < size_in2; k2++ )
	{
                fread( &workbyte, 1, 1, fp_in2 );
                if( workbyte != 10 )
                { if( workbyte != 13 ) // NON UNIX
                  { if( LINE10len2 < 255 ) { LINE10_2[ LINE10len2 ] = workbyte; }
                    LINE10len2++;
                  }
                  else
                  {
                  }
		}
		else
                { if( 1 <= LINE10len2 && LINE10len2 <= 255 )
                  { LINE10_2[ LINE10len2 ] = 0;
		    //PatternLEN = KAZE_strlen(LINE10_2);

// Nested Segment [[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
			// *\t |
			k3=0;
		        //for( k = 0; k < LINE10len2; k++ ) {
				strcpy(wrd, LINE10_2);
			//	if (k==k3++) wrd[ k ] = '$';
				fprintf( fp_in3, "*\t%s", wrd);
				fprintf( fp_in3, "%s\n", "|\0"); // Add an extra '|' since the incoming words are not wildcarded
			//}
// Nested Segment ]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

        LINE10len2 = 0;
LINE10_2[ LINE10len2 ] = 0;
                  }
                }
        } // k2 'for'
fclose( fp_in3 );
fclose( fp_in2 );
if( ( fp_in2 = fopen( "Tchutchelo_converted.ini", "rb" ) ) == NULL )
{ printf( "Tchutchelo: Can't open Tchutchelo_converted.ini file.\n" ); return( 1 ); }
fseek( fp_in2, 0L, SEEK_END );
size_in2 = ftell( fp_in2 );
fseek( fp_in2, 0L, SEEK_SET );
// Creating all patterns for xgram matching )))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))
}


if ( argc == 3 && strcmp("/suggest\0",argv[2]) == 0 ) {
// Creating all patterns for suggestion <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
if( ( fp_in3 = fopen( "Tchutchelo_converted.ini", "wb" ) ) == NULL )
{ printf( "Tchutchelo: Can't open Tchutchelo_converted.ini file.\n" ); return( 1 ); }

printf( "Creating 'Tchutchelo_converted.ini' file ...\n" ); 
LINE10len2 = 0;
fseek( fp_in2, 0L, SEEK_SET );
        for( k2 = 0; k2 < size_in2; k2++ )
	{
                fread( &workbyte, 1, 1, fp_in2 );
                if( workbyte != 10 )
                { if( workbyte != 13 ) // NON UNIX
                  { if( LINE10len2 < 255 ) { LINE10_2[ LINE10len2 ] = workbyte; }
                    LINE10len2++;
                  }
                  else
                  {
                  }
		}
		else
                { if( 1 <= LINE10len2 && LINE10len2 <= 255 )
                  { LINE10_2[ LINE10len2 ] = 0;
		    //PatternLEN = KAZE_strlen(LINE10_2);

// Nested Segment [[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
			// $
			k3=0;
		        for( k = 0; k < LINE10len2; k++ ) {
				strcpy(wrd, LINE10_2);
				if (k==k3++) wrd[ k ] = '$';
				fprintf( fp_in3, "%s", wrd);
				fprintf( fp_in3, "%s\n", "|\0"); // Add an extra '|' since the incoming words are not wildcarded
			}
			// $$
			k3=0;
		        for( k = 0; k < LINE10len2-(1); k++ ) {
				strcpy(wrd, LINE10_2);
				if (k==k3++) {wrd[ k ] = '$'; wrd[ k+1 ] = '$';}
				fprintf( fp_in3, "%s", wrd);
				fprintf( fp_in3, "%s\n", "|\0"); // Add an extra '|' since the incoming words are not wildcarded
			}
			// ^
			k3=0;
		        for( k = 0; k < LINE10len2-1; k++ ) {
				strcpy(wrd, LINE10_2);
				if (k==k3++)
				        for( k2 = 0; k2 <= k; k2++ )
						wrd[ (LINE10len2-1)-k2 ] = '^';
				fprintf( fp_in3, "%s", wrd);
				fprintf( fp_in3, "%s\n", "|\0"); // Add an extra '|' since the incoming words are not wildcarded
			}
// Nested Segment ]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

        LINE10len2 = 0;
LINE10_2[ LINE10len2 ] = 0;
                  }
                }
        } // k2 'for'
fclose( fp_in3 );
fclose( fp_in2 );
if( ( fp_in2 = fopen( "Tchutchelo_converted.ini", "rb" ) ) == NULL )
{ printf( "Tchutchelo: Can't open Tchutchelo_converted.ini file.\n" ); return( 1 ); }
fseek( fp_in2, 0L, SEEK_END );
size_in2 = ftell( fp_in2 );
fseek( fp_in2, 0L, SEEK_SET );
// Creating all patterns for suggestion >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
}

LINE10len2 = 0;
fseek( fp_in2, 0L, SEEK_SET );
        for( k2 = 0; k2 < size_in2; k2++ )
	{
                fread( &workbyte, 1, 1, fp_in2 );
                if( workbyte != 10 )
                { if( workbyte != 13 ) // NON UNIX
                  { if( LINE10len2 < 255 ) { LINE10_2[ LINE10len2 ] = workbyte; }
                    LINE10len2++;
                  }
                  else
                  {
                  }
		}
		else
                { if( 1 <= LINE10len2 && LINE10len2 <= 255 )
                  { LINE10_2[ LINE10len2 ] = 0;
		    //PatternLEN = KAZE_strlen(LINE10_2);

DumpedLinesOLD = DumpedLines;
if ( argc == 3 && strcmp("/suggest\0",argv[2]) == 0 && strstr( LINE10_2, "^|\0") == NULL ) SkipNextSubStagesFlag = 0;  
if ( SkipNextSubStagesFlag == 0 ) {
// Nested Segment [[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
fseek( fp_in, 0L, SEEK_END );
size_in = ftell( fp_in );
fseek( fp_in, 0L, SEEK_SET );

printf( "Tchutcheling '%s' ...\n", LINE10_2 ); 
if ( argc == 3 && strcmp("/suggest\0",argv[2]) == 0 )
	fprintf( fp_outLOG, "The group of '%s':\r\n", LINE10_2 ); 

        NumberOfLines = 0;
        FilesLEN = 0;
        LINE10len = 0;
	LongestLine=0;
	ShortestLine=~0; // 4,294,967,295
        for( k = 0; k < size_in; k++ )
	{
                fread( &workbyte, 1, 1, fp_in );
                if( workbyte != 10 )
                { if( workbyte != 13 ) // NON UNIX
                  { if( LINE10len < 255 ) { LINE10[ LINE10len ] = workbyte; }
                    LINE10len++;
                  }
                  else
                  {
                  }
		}
		else
                { if( 1 <= LINE10len && LINE10len <= 255 )
                  { LINE10[ LINE10len ] = 0;
if( ( fp_inLINE = fopen( LINE10, "rb" ) ) == NULL )
{ printf( "Tchutchelo: Can't open file %s \n", LINE10 ); return( 1 ); }

//fseek( fp_inLINE, 0L, SEEK_END );  //Rev. 12
//size_inLINE = ftell( fp_inLINE );  //Rev. 12
//fseek( fp_inLINE, 0L, SEEK_SET );  //Rev. 12

#if defined(_WIN32_ENVIRONMENT_)
   // 64bit:
_lseeki64( fileno(fp_inLINE), 0L, SEEK_END );
size_inLINESIXFOUR = _telli64( fileno(fp_inLINE) );
_lseeki64( fileno(fp_inLINE), 0L, SEEK_SET );
#else
   // 64bit:
fseeko( fp_inLINE, 0L, SEEK_END );
size_inLINESIXFOUR = ftello( fp_inLINE );
fseeko( fp_inLINE, 0L, SEEK_SET );
#endif /* defined(_WIN32_ENVIRONMENT_)  */

        //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	FilesLEN = FilesLEN + size_inLINESIXFOUR;
	wrdlen = 0;
        for( i = 0; i < size_inLINESIXFOUR; i++ )
	{

                // ~~~~~~~~~~~~ Buffering fread, 10x faster [
                if (workKoffset == -1) {
                        if (i + 1024*128 < size_inLINESIXFOUR) {
                                fread( &workK[0], 1, 1024*128, fp_inLINE );
                                workKoffset = 0;
                                workbyte = workK[workKoffset];
                        } else 
                        fread( &workbyte, 1, 1, fp_inLINE );
                } else {
                        workKoffset++;
                        workbyte = workK[workKoffset];
                        if (workKoffset == 1024*128 - 1) workKoffset = -1;
                }
                // ~~~~~~~~~~~~ Buffering fread, 10x faster ]
               
                // ~~~~~~~~~~~~ UnBuffered fread, 10x slower [
                        //fread( &workbyte, 1, 1, fp_inLINE );
                // ~~~~~~~~~~~~ UnBuffered fread, 10x slower ]

                        if( wrdlen < MaxLineLength +1+1)
                        { wrd[ wrdlen ] = KAZE_tolower( workbyte ); }

                        if (workbyte == 10) {NumberOfLines++;
                            if (wrdlen > LongestLine) LongestLine=wrdlen;
                            if (wrdlen < ShortestLine) ShortestLine=wrdlen;
// Wildcard search [
                        if ( 0 < wrdlen && wrdlen < MaxLineLength +1+1)
			{
                            wrd[ wrdlen ] = 0;
				if ( CompareWildCardWithName ( LINE10_2, wrd ) ) {
					//printf("%s\n", wrd);
					fprintf( fp_outLOG, "%s\n", wrd); DumpedLines++;
				if ((DumpedLines & 0xff) == 0xff)
					//printf( "Dumped lines i.e. hits so far: %s\r", _ui64toaKAZEcomma(DumpedLines, llTOaDigits, 10) ); 
					fflush(fp_outLOG); // Not sure: CTRL+C doesn't flush?!
				}

			}
// Wildcard search ]
                            wrdlen = 0;
                        }
                        else wrdlen++;

        } // i 'for'
        //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        LINE10len = 0;
LINE10[ LINE10len ] = 0;
fclose( fp_inLINE );
fflush(fp_outLOG); // Not sure: CTRL+C doesn't flush?!
                  }
                }
        } // k 'for'
// Nested Segment ]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
}
if ( argc == 3 && strcmp("/suggest\0",argv[2]) == 0 && strstr( LINE10_2, "^|\0") && DumpedLinesOLD != DumpedLines ) SkipNextSubStagesFlag = 1;

        LINE10len2 = 0;
LINE10_2[ LINE10len2 ] = 0;
                  }
                }
        } // k2 'for'
fclose( fp_in2 );

(void) time(&t3);
if (t3 <= t1) {t3 = t1; t3++;}
					printf( "Dumped lines i.e. hits so far: %s\n", _ui64toaKAZEcomma(DumpedLines, llTOaDigits, 10) ); 
printf( "\nTchutchelo: Encountered lines in all files: %s\n", _ui64toaKAZEcomma(NumberOfLines, llTOaDigits, 10) ); 
printf( "Tchutchelo: Shortest line (CR included): %s\n", _ui64toaKAZEcomma(ShortestLine, llTOaDigits, 10) ); 
printf( "Tchutchelo: Longest line (CR included): %s\n", _ui64toaKAZEcomma(LongestLine, llTOaDigits, 10) ); 
printf( "Tchutchelo: Dumped lines i.e. hits: %s\n", _ui64toaKAZEcomma(DumpedLines, llTOaDigits, 10) ); 
printf( "Tchutchelo: Performance: %sKB/s\n", _ui64toaKAZEcomma((FilesLEN>>10)/((int) t3-t1), llTOaDigits, 10) );
return(0);
  }
