/*-----------------------------------------------------------*/
/* Block Sorting, Lossless Data Compression Library.         */
/* Static tables of constant values                          */
/*-----------------------------------------------------------*/

/*--

This file is a part of bsc and/or libbsc, a program and a library for
lossless, block-sorting data compression.

Copyright (c) 2009-2010 Ilya Grebnov <ilya.grebnov@libbsc.com>

The bsc and libbsc is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation; either version 3 of the License, or (at your
option) any later version.

The bsc and libbsc is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
License for more details.

You should have received a copy of the GNU Lesser General Public License
along with the bsc and libbsc. If not, see http://www.gnu.org/licenses/.

Please see the files COPYING and COPYING.LIB for full copyright information.

See also the bsc and libbsc web site:
  http://libbsc.com/ for more information.

--*/

#ifndef _LIBBSC_FILTERS_TABLES_H
#define _LIBBSC_FILTERS_TABLES_H

#include "../../common/common.h"

static const unsigned int bsc_code_table[4096] =
{
         0,      0,  65536, 103872, 131072, 152169, 169408, 183982, 196608, 207744, 217705, 226717,
    234944, 242512, 249518, 256041, 262144, 267875, 273280, 278392, 283241, 287854, 292253, 296456,
    300480, 304339, 308048, 311616, 315054, 318372, 321577, 324678, 327680, 330589, 333411, 336152,
    338816, 341406, 343928, 346384, 348777, 351112, 353390, 355615, 357789, 359914, 361992, 364025,
    366016, 367965, 369875, 371748, 373584, 375384, 377152, 378887, 380590, 382264, 383908, 385524,
    387113, 388676, 390214, 391727, 393216, 394681, 396125, 397547, 398947, 400328, 401688, 403029,
    404352, 405656, 406942, 408211, 409464, 410700, 411920, 413124, 414313, 415488, 416648, 417794,
    418926, 420045, 421151, 422244, 423325, 424393, 425450, 426494, 427528, 428550, 429561, 430562,
    431552, 432531, 433501, 434461, 435411, 436352, 437284, 438206, 439120, 440024, 440920, 441808,
    442688, 443559, 444423, 445278, 446126, 446967, 447800, 448626, 449444, 450256, 451060, 451858,
    452649, 453434, 454212, 454984, 455750, 456509, 457263, 458010, 458752, 459487, 460217, 460942,
    461661, 462374, 463083, 463786, 464483, 465176, 465864, 466546, 467224, 467897, 468565, 469229,
    469888, 470542, 471192, 471837, 472478, 473115, 473747, 474376, 475000, 475620, 476236, 476848,
    477456, 478060, 478660, 479257, 479849, 480438, 481024, 481606, 482184, 482759, 483330, 483898,
    484462, 485024, 485581, 486136, 486687, 487235, 487780, 488322, 488861, 489396, 489929, 490459,
    490986, 491509, 492030, 492548, 493064, 493576, 494086, 494593, 495097, 495599, 496098, 496594,
    497088, 497579, 498067, 498553, 499037, 499518, 499997, 500473, 500947, 501419, 501888, 502355,
    502820, 503282, 503742, 504200, 504656, 505109, 505560, 506009, 506456, 506901, 507344, 507785,
    508224, 508661, 509095, 509528, 509959, 510387, 510814, 511239, 511662, 512083, 512503, 512920,
    513336, 513750, 514162, 514572, 514980, 515387, 515792, 516195, 516596, 516996, 517394, 517791,
    518185, 518579, 518970, 519360, 519748, 520135, 520520, 520904, 521286, 521666, 522045, 522423,
    522799, 523173, 523546, 523917, 524288, 524656, 525023, 525389, 525753, 526116, 526478, 526838,
    527197, 527554, 527910, 528265, 528619, 528971, 529322, 529671, 530019, 530366, 530712, 531057,
    531400, 531742, 532082, 532422, 532760, 533097, 533433, 533768, 534101, 534434, 534765, 535095,
    535424, 535751, 536078, 536403, 536728, 537051, 537373, 537694, 538014, 538333, 538651, 538968,
    539283, 539598, 539912, 540224, 540536, 540846, 541156, 541464, 541772, 542078, 542384, 542688,
    542992, 543294, 543596, 543896, 544196, 544495, 544793, 545089, 545385, 545680, 545974, 546268,
    546560, 546851, 547142, 547431, 547720, 548008, 548295, 548581, 548866, 549150, 549434, 549717,
    549998, 550279, 550560, 550839, 551117, 551395, 551672, 551948, 552223, 552498, 552771, 553044,
    553316, 553588, 553858, 554128, 554397, 554665, 554932, 555199, 555465, 555730, 555995, 556259,
    556522, 556784, 557045, 557306, 557566, 557826, 558084, 558342, 558600, 558856, 559112, 559367,
    559622, 559876, 560129, 560381, 560633, 560884, 561135, 561384, 561634, 561882, 562130, 562377,
    562624, 562870, 563115, 563359, 563603, 563847, 564089, 564332, 564573, 564814, 565054, 565294,
    565533, 565771, 566009, 566247, 566483, 566719, 566955, 567190, 567424, 567658, 567891, 568124,
    568356, 568587, 568818, 569048, 569278, 569507, 569736, 569964, 570192, 570419, 570645, 570871,
    571096, 571321, 571545, 571769, 571992, 572215, 572437, 572659, 572880, 573101, 573321, 573541,
    573760, 573978, 574197, 574414, 574631, 574848, 575064, 575280, 575495, 575709, 575923, 576137,
    576350, 576563, 576775, 576987, 577198, 577409, 577619, 577829, 578039, 578248, 578456, 578664,
    578872, 579079, 579286, 579492, 579698, 579903, 580108, 580312, 580516, 580720, 580923, 581125,
    581328, 581530, 581731, 581932, 582132, 582332, 582532, 582731, 582930, 583129, 583327, 583524,
    583721, 583918, 584115, 584311, 584506, 584701, 584896, 585090, 585284, 585478, 585671, 585864,
    586056, 586248, 586440, 586631, 586822, 587012, 587202, 587392, 587581, 587770, 587959, 588147,
    588335, 588522, 588709, 588896, 589082, 589268, 589453, 589639, 589824, 590008, 590192, 590376,
    590559, 590742, 590925, 591107, 591289, 591471, 591652, 591833, 592014, 592194, 592374, 592554,
    592733, 592912, 593090, 593269, 593446, 593624, 593801, 593978, 594155, 594331, 594507, 594682,
    594858, 595033, 595207, 595382, 595555, 595729, 595902, 596075, 596248, 596421, 596593, 596764,
    596936, 597107, 597278, 597448, 597618, 597788, 597958, 598127, 598296, 598465, 598633, 598801,
    598969, 599137, 599304, 599471, 599637, 599804, 599970, 600135, 600301, 600466, 600631, 600795,
    600960, 601124, 601287, 601451, 601614, 601777, 601939, 602102, 602264, 602426, 602587, 602748,
    602909, 603070, 603230, 603390, 603550, 603710, 603869, 604028, 604187, 604345, 604504, 604662,
    604819, 604977, 605134, 605291, 605448, 605604, 605760, 605916, 606072, 606227, 606382, 606537,
    606692, 606846, 607000, 607154, 607308, 607461, 607614, 607767, 607920, 608072, 608224, 608376,
    608528, 608679, 608830, 608981, 609132, 609282, 609432, 609582, 609732, 609882, 610031, 610180,
    610329, 610477, 610625, 610774, 610921, 611069, 611216, 611364, 611510, 611657, 611804, 611950,
    612096, 612242, 612387, 612533, 612678, 612823, 612967, 613112, 613256, 613400, 613544, 613687,
    613831, 613974, 614117, 614260, 614402, 614544, 614686, 614828, 614970, 615111, 615253, 615394,
    615534, 615675, 615815, 615956, 616096, 616235, 616375, 616514, 616653, 616792, 616931, 617070,
    617208, 617346, 617484, 617622, 617759, 617897, 618034, 618171, 618307, 618444, 618580, 618716,
    618852, 618988, 619124, 619259, 619394, 619529, 619664, 619798, 619933, 620067, 620201, 620335,
    620468, 620602, 620735, 620868, 621001, 621134, 621266, 621399, 621531, 621663, 621795, 621926,
    622058, 622189, 622320, 622451, 622581, 622712, 622842, 622972, 623102, 623232, 623362, 623491,
    623620, 623749, 623878, 624007, 624136, 624264, 624392, 624520, 624648, 624776, 624903, 625031,
    625158, 625285, 625412, 625538, 625665, 625791, 625917, 626043, 626169, 626295, 626420, 626545,
    626671, 626796, 626920, 627045, 627170, 627294, 627418, 627542, 627666, 627790, 627913, 628036,
    628160, 628283, 628406, 628528, 628651, 628773, 628895, 629017, 629139, 629261, 629383, 629504,
    629625, 629747, 629868, 629988, 630109, 630230, 630350, 630470, 630590, 630710, 630830, 630950,
    631069, 631188, 631307, 631426, 631545, 631664, 631783, 631901, 632019, 632137, 632255, 632373,
    632491, 632608, 632726, 632843, 632960, 633077, 633194, 633310, 633427, 633543, 633660, 633776,
    633892, 634007, 634123, 634239, 634354, 634469, 634584, 634699, 634814, 634929, 635043, 635158,
    635272, 635386, 635500, 635614, 635728, 635841, 635955, 636068, 636181, 636294, 636407, 636520,
    636632, 636745, 636857, 636969, 637081, 637193, 637305, 637417, 637528, 637640, 637751, 637862,
    637973, 638084, 638195, 638306, 638416, 638527, 638637, 638747, 638857, 638967, 639077, 639186,
    639296, 639405, 639514, 639624, 639733, 639841, 639950, 640059, 640167, 640276, 640384, 640492,
    640600, 640708, 640816, 640923, 641031, 641138, 641245, 641352, 641459, 641566, 641673, 641780,
    641886, 641993, 642099, 642205, 642311, 642417, 642523, 642629, 642734, 642840, 642945, 643050,
    643155, 643260, 643365, 643470, 643575, 643679, 643784, 643888, 643992, 644096, 644200, 644304,
    644408, 644511, 644615, 644718, 644822, 644925, 645028, 645131, 645234, 645336, 645439, 645541,
    645644, 645746, 645848, 645950, 646052, 646154, 646256, 646357, 646459, 646560, 646661, 646763,
    646864, 646965, 647066, 647166, 647267, 647367, 647468, 647568, 647668, 647768, 647868, 647968,
    648068, 648168, 648267, 648367, 648466, 648566, 648665, 648764, 648863, 648962, 649060, 649159,
    649257, 649356, 649454, 649552, 649651, 649749, 649847, 649944, 650042, 650140, 650237, 650335,
    650432, 650529, 650626, 650723, 650820, 650917, 651014, 651110, 651207, 651303, 651400, 651496,
    651592, 651688, 651784, 651880, 651976, 652071, 652167, 652262, 652358, 652453, 652548, 652643,
    652738, 652833, 652928, 653023, 653117, 653212, 653306, 653400, 653495, 653589, 653683, 653777,
    653871, 653964, 654058, 654151, 654245, 654338, 654432, 654525, 654618, 654711, 654804, 654897,
    654989, 655082, 655175, 655267, 655360, 655452, 655544, 655636, 655728, 655820, 655912, 656004,
    656095, 656187, 656278, 656370, 656461, 656552, 656643, 656734, 656825, 656916, 657007, 657098,
    657188, 657279, 657369, 657460, 657550, 657640, 657730, 657820, 657910, 658000, 658090, 658179,
    658269, 658358, 658448, 658537, 658626, 658716, 658805, 658894, 658982, 659071, 659160, 659249,
    659337, 659426, 659514, 659602, 659691, 659779, 659867, 659955, 660043, 660131, 660218, 660306,
    660394, 660481, 660569, 660656, 660743, 660830, 660918, 661005, 661091, 661178, 661265, 661352,
    661438, 661525, 661611, 661698, 661784, 661870, 661957, 662043, 662129, 662214, 662300, 662386,
    662472, 662557, 662643, 662728, 662814, 662899, 662984, 663069, 663154, 663239, 663324, 663409,
    663494, 663579, 663663, 663748, 663832, 663917, 664001, 664085, 664169, 664253, 664337, 664421,
    664505, 664589, 664673, 664756, 664840, 664923, 665007, 665090, 665173, 665257, 665340, 665423,
    665506, 665589, 665671, 665754, 665837, 665919, 666002, 666084, 666167, 666249, 666331, 666414,
    666496, 666578, 666660, 666742, 666823, 666905, 666987, 667068, 667150, 667231, 667313, 667394,
    667475, 667557, 667638, 667719, 667800, 667881, 667962, 668042, 668123, 668204, 668284, 668365,
    668445, 668526, 668606, 668686, 668766, 668846, 668926, 669006, 669086, 669166, 669246, 669325,
    669405, 669485, 669564, 669644, 669723, 669802, 669881, 669961, 670040, 670119, 670198, 670277,
    670355, 670434, 670513, 670591, 670670, 670748, 670827, 670905, 670984, 671062, 671140, 671218,
    671296, 671374, 671452, 671530, 671608, 671685, 671763, 671841, 671918, 671996, 672073, 672150,
    672228, 672305, 672382, 672459, 672536, 672613, 672690, 672767, 672844, 672920, 672997, 673074,
    673150, 673227, 673303, 673379, 673456, 673532, 673608, 673684, 673760, 673836, 673912, 673988,
    674064, 674139, 674215, 674291, 674366, 674442, 674517, 674592, 674668, 674743, 674818, 674893,
    674968, 675043, 675118, 675193, 675268, 675343, 675418, 675492, 675567, 675641, 675716, 675790,
    675865, 675939, 676013, 676087, 676161, 676236, 676310, 676383, 676457, 676531, 676605, 676679,
    676752, 676826, 676900, 676973, 677046, 677120, 677193, 677266, 677340, 677413, 677486, 677559,
    677632, 677705, 677778, 677851, 677923, 677996, 678069, 678141, 678214, 678286, 678359, 678431,
    678503, 678576, 678648, 678720, 678792, 678864, 678936, 679008, 679080, 679152, 679223, 679295,
    679367, 679438, 679510, 679581, 679653, 679724, 679796, 679867, 679938, 680009, 680080, 680151,
    680222, 680293, 680364, 680435, 680506, 680577, 680647, 680718, 680789, 680859, 680930, 681000,
    681070, 681141, 681211, 681281, 681351, 681422, 681492, 681562, 681632, 681701, 681771, 681841,
    681911, 681981, 682050, 682120, 682189, 682259, 682328, 682398, 682467, 682536, 682606, 682675,
    682744, 682813, 682882, 682951, 683020, 683089, 683158, 683226, 683295, 683364, 683433, 683501,
    683570, 683638, 683707, 683775, 683843, 683912, 683980, 684048, 684116, 684184, 684252, 684320,
    684388, 684456, 684524, 684592, 684660, 684727, 684795, 684863, 684930, 684998, 685065, 685132,
    685200, 685267, 685334, 685402, 685469, 685536, 685603, 685670, 685737, 685804, 685871, 685938,
    686004, 686071, 686138, 686205, 686271, 686338, 686404, 686471, 686537, 686604, 686670, 686736,
    686802, 686869, 686935, 687001, 687067, 687133, 687199, 687265, 687331, 687396, 687462, 687528,
    687594, 687659, 687725, 687790, 687856, 687921, 687987, 688052, 688117, 688183, 688248, 688313,
    688378, 688443, 688508, 688573, 688638, 688703, 688768, 688833, 688898, 688962, 689027, 689092,
    689156, 689221, 689285, 689350, 689414, 689479, 689543, 689607, 689672, 689736, 689800, 689864,
    689928, 689992, 690056, 690120, 690184, 690248, 690312, 690376, 690439, 690503, 690567, 690630,
    690694, 690757, 690821, 690884, 690948, 691011, 691074, 691138, 691201, 691264, 691327, 691390,
    691453, 691516, 691579, 691642, 691705, 691768, 691831, 691893, 691956, 692019, 692081, 692144,
    692207, 692269, 692332, 692394, 692456, 692519, 692581, 692643, 692706, 692768, 692830, 692892,
    692954, 693016, 693078, 693140, 693202, 693264, 693326, 693387, 693449, 693511, 693572, 693634,
    693696, 693757, 693819, 693880, 693942, 694003, 694064, 694126, 694187, 694248, 694309, 694370,
    694431, 694492, 694553, 694614, 694675, 694736, 694797, 694858, 694919, 694980, 695040, 695101,
    695161, 695222, 695283, 695343, 695404, 695464, 695524, 695585, 695645, 695705, 695766, 695826,
    695886, 695946, 696006, 696066, 696126, 696186, 696246, 696306, 696366, 696426, 696486, 696545,
    696605, 696665, 696724, 696784, 696843, 696903, 696962, 697022, 697081, 697141, 697200, 697259,
    697319, 697378, 697437, 697496, 697555, 697614, 697673, 697732, 697791, 697850, 697909, 697968,
    698027, 698086, 698144, 698203, 698262, 698320, 698379, 698438, 698496, 698555, 698613, 698671,
    698730, 698788, 698846, 698905, 698963, 699021, 699079, 699137, 699196, 699254, 699312, 699370,
    699428, 699485, 699543, 699601, 699659, 699717, 699775, 699832, 699890, 699948, 700005, 700063,
    700120, 700178, 700235, 700293, 700350, 700407, 700465, 700522, 700579, 700636, 700694, 700751,
    700808, 700865, 700922, 700979, 701036, 701093, 701150, 701207, 701264, 701320, 701377, 701434,
    701491, 701547, 701604, 701660, 701717, 701774, 701830, 701886, 701943, 701999, 702056, 702112,
    702168, 702225, 702281, 702337, 702393, 702449, 702505, 702561, 702617, 702673, 702729, 702785,
    702841, 702897, 702953, 703009, 703064, 703120, 703176, 703232, 703287, 703343, 703398, 703454,
    703509, 703565, 703620, 703676, 703731, 703786, 703842, 703897, 703952, 704007, 704063, 704118,
    704173, 704228, 704283, 704338, 704393, 704448, 704503, 704558, 704613, 704668, 704722, 704777,
    704832, 704887, 704941, 704996, 705050, 705105, 705160, 705214, 705269, 705323, 705377, 705432,
    705486, 705540, 705595, 705649, 705703, 705757, 705812, 705866, 705920, 705974, 706028, 706082,
    706136, 706190, 706244, 706298, 706352, 706405, 706459, 706513, 706567, 706620, 706674, 706728,
    706781, 706835, 706888, 706942, 706995, 707049, 707102, 707156, 707209, 707262, 707316, 707369,
    707422, 707476, 707529, 707582, 707635, 707688, 707741, 707794, 707847, 707900, 707953, 708006,
    708059, 708112, 708165, 708218, 708270, 708323, 708376, 708428, 708481, 708534, 708586, 708639,
    708691, 708744, 708796, 708849, 708901, 708954, 709006, 709058, 709111, 709163, 709215, 709268,
    709320, 709372, 709424, 709476, 709528, 709580, 709632, 709684, 709736, 709788, 709840, 709892,
    709944, 709996, 710047, 710099, 710151, 710203, 710254, 710306, 710358, 710409, 710461, 710512,
    710564, 710615, 710667, 710718, 710770, 710821, 710872, 710924, 710975, 711026, 711077, 711129,
    711180, 711231, 711282, 711333, 711384, 711435, 711486, 711537, 711588, 711639, 711690, 711741,
    711792, 711843, 711893, 711944, 711995, 712046, 712096, 712147, 712197, 712248, 712299, 712349,
    712400, 712450, 712501, 712551, 712602, 712652, 712702, 712753, 712803, 712853, 712903, 712954,
    713004, 713054, 713104, 713154, 713204, 713254, 713304, 713355, 713404, 713454, 713504, 713554,
    713604, 713654, 713704, 713754, 713803, 713853, 713903, 713953, 714002, 714052, 714102, 714151,
    714201, 714250, 714300, 714349, 714399, 714448, 714498, 714547, 714596, 714646, 714695, 714744,
    714793, 714843, 714892, 714941, 714990, 715039, 715088, 715138, 715187, 715236, 715285, 715334,
    715383, 715431, 715480, 715529, 715578, 715627, 715676, 715725, 715773, 715822, 715871, 715919,
    715968, 716017, 716065, 716114, 716162, 716211, 716259, 716308, 716356, 716405, 716453, 716502,
    716550, 716598, 716646, 716695, 716743, 716791, 716839, 716888, 716936, 716984, 717032, 717080,
    717128, 717176, 717224, 717272, 717320, 717368, 717416, 717464, 717512, 717560, 717607, 717655,
    717703, 717751, 717798, 717846, 717894, 717941, 717989, 718037, 718084, 718132, 718179, 718227,
    718274, 718322, 718369, 718416, 718464, 718511, 718559, 718606, 718653, 718700, 718748, 718795,
    718842, 718889, 718936, 718983, 719031, 719078, 719125, 719172, 719219, 719266, 719313, 719360,
    719407, 719453, 719500, 719547, 719594, 719641, 719687, 719734, 719781, 719828, 719874, 719921,
    719968, 720014, 720061, 720107, 720154, 720200, 720247, 720293, 720340, 720386, 720433, 720479,
    720525, 720572, 720618, 720664, 720711, 720757, 720803, 720849, 720896, 720942, 720988, 721034,
    721080, 721126, 721172, 721218, 721264, 721310, 721356, 721402, 721448, 721494, 721540, 721585,
    721631, 721677, 721723, 721769, 721814, 721860, 721906, 721951, 721997, 722043, 722088, 722134,
    722179, 722225, 722270, 722316, 722361, 722407, 722452, 722498, 722543, 722588, 722634, 722679,
    722724, 722770, 722815, 722860, 722905, 722950, 722996, 723041, 723086, 723131, 723176, 723221,
    723266, 723311, 723356, 723401, 723446, 723491, 723536, 723581, 723626, 723671, 723715, 723760,
    723805, 723850, 723894, 723939, 723984, 724028, 724073, 724118, 724162, 724207, 724252, 724296,
    724341, 724385, 724430, 724474, 724518, 724563, 724607, 724652, 724696, 724740, 724785, 724829,
    724873, 724918, 724962, 725006, 725050, 725094, 725138, 725183, 725227, 725271, 725315, 725359,
    725403, 725447, 725491, 725535, 725579, 725623, 725667, 725711, 725754, 725798, 725842, 725886,
    725930, 725973, 726017, 726061, 726105, 726148, 726192, 726236, 726279, 726323, 726366, 726410,
    726454, 726497, 726541, 726584, 726627, 726671, 726714, 726758, 726801, 726844, 726888, 726931,
    726974, 727018, 727061, 727104, 727147, 727191, 727234, 727277, 727320, 727363, 727406, 727449,
    727493, 727536, 727579, 727622, 727665, 727708, 727750, 727793, 727836, 727879, 727922, 727965,
    728008, 728051, 728093, 728136, 728179, 728222, 728264, 728307, 728350, 728392, 728435, 728478,
    728520, 728563, 728605, 728648, 728690, 728733, 728775, 728818, 728860, 728903, 728945, 728988,
    729030, 729072, 729115, 729157, 729199, 729241, 729284, 729326, 729368, 729410, 729453, 729495,
    729537, 729579, 729621, 729663, 729705, 729747, 729789, 729831, 729873, 729915, 729957, 729999,
    730041, 730083, 730125, 730167, 730209, 730250, 730292, 730334, 730376, 730418, 730459, 730501,
    730543, 730584, 730626, 730668, 730709, 730751, 730793, 730834, 730876, 730917, 730959, 731000,
    731042, 731083, 731125, 731166, 731207, 731249, 731290, 731331, 731373, 731414, 731455, 731497,
    731538, 731579, 731620, 731662, 731703, 731744, 731785, 731826, 731867, 731909, 731950, 731991,
    732032, 732073, 732114, 732155, 732196, 732237, 732278, 732319, 732359, 732400, 732441, 732482,
    732523, 732564, 732604, 732645, 732686, 732727, 732767, 732808, 732849, 732890, 732930, 732971,
    733011, 733052, 733093, 733133, 733174, 733214, 733255, 733295, 733336, 733376, 733417, 733457,
    733498, 733538, 733578, 733619, 733659, 733699, 733740, 733780, 733820, 733861, 733901, 733941,
    733981, 734021, 734062, 734102, 734142, 734182, 734222, 734262, 734302, 734342, 734382, 734422,
    734462, 734502, 734542, 734582, 734622, 734662, 734702, 734742, 734782, 734822, 734861, 734901,
    734941, 734981, 735021, 735060, 735100, 735140, 735180, 735219, 735259, 735299, 735338, 735378,
    735417, 735457, 735497, 735536, 735576, 735615, 735655, 735694, 735734, 735773, 735813, 735852,
    735891, 735931, 735970, 736009, 736049, 736088, 736127, 736167, 736206, 736245, 736284, 736324,
    736363, 736402, 736441, 736480, 736520, 736559, 736598, 736637, 736676, 736715, 736754, 736793,
    736832, 736871, 736910, 736949, 736988, 737027, 737066, 737105, 737144, 737183, 737221, 737260,
    737299, 737338, 737377, 737415, 737454, 737493, 737532, 737570, 737609, 737648, 737686, 737725,
    737764, 737802, 737841, 737879, 737918, 737957, 737995, 738034, 738072, 738111, 738149, 738188,
    738226, 738264, 738303, 738341, 738380, 738418, 738456, 738495, 738533, 738571, 738610, 738648,
    738686, 738724, 738763, 738801, 738839, 738877, 738915, 738953, 738992, 739030, 739068, 739106,
    739144, 739182, 739220, 739258, 739296, 739334, 739372, 739410, 739448, 739486, 739524, 739562,
    739600, 739637, 739675, 739713, 739751, 739789, 739827, 739864, 739902, 739940, 739978, 740015,
    740053, 740091, 740128, 740166, 740204, 740241, 740279, 740317, 740354, 740392, 740429, 740467,
    740504, 740542, 740579, 740617, 740654, 740692, 740729, 740767, 740804, 740841, 740879, 740916,
    740954, 740991, 741028, 741066, 741103, 741140, 741177, 741215, 741252, 741289, 741326, 741363,
    741401, 741438, 741475, 741512, 741549, 741586, 741623, 741660, 741697, 741734, 741772, 741809,
    741846, 741883, 741919, 741956, 741993, 742030, 742067, 742104, 742141, 742178, 742215, 742252,
    742288, 742325, 742362, 742399, 742436, 742472, 742509, 742546, 742582, 742619, 742656, 742693,
    742729, 742766, 742802, 742839, 742876, 742912, 742949, 742985, 743022, 743058, 743095, 743131,
    743168, 743204, 743241, 743277, 743314, 743350, 743387, 743423, 743459, 743496, 743532, 743568,
    743605, 743641, 743677, 743713, 743750, 743786, 743822, 743858, 743895, 743931, 743967, 744003,
    744039, 744075, 744112, 744148, 744184, 744220, 744256, 744292, 744328, 744364, 744400, 744436,
    744472, 744508, 744544, 744580, 744616, 744652, 744688, 744724, 744759, 744795, 744831, 744867,
    744903, 744939, 744974, 745010, 745046, 745082, 745117, 745153, 745189, 745225, 745260, 745296,
    745332, 745367, 745403, 745438, 745474, 745510, 745545, 745581, 745616, 745652, 745687, 745723,
    745758, 745794, 745829, 745865, 745900, 745936, 745971, 746007, 746042, 746077, 746113, 746148,
    746183, 746219, 746254, 746289, 746325, 746360, 746395, 746430, 746466, 746501, 746536, 746571,
    746606, 746642, 746677, 746712, 746747, 746782, 746817, 746852, 746887, 746922, 746958, 746993,
    747028, 747063, 747098, 747133, 747168, 747202, 747237, 747272, 747307, 747342, 747377, 747412,
    747447, 747482, 747517, 747551, 747586, 747621, 747656, 747691, 747725, 747760, 747795, 747830,
    747864, 747899, 747934, 747968, 748003, 748038, 748072, 748107, 748142, 748176, 748211, 748245,
    748280, 748314, 748349, 748383, 748418, 748453, 748487, 748521, 748556, 748590, 748625, 748659,
    748694, 748728, 748762, 748797, 748831, 748866, 748900, 748934, 748969, 749003, 749037, 749071,
    749106, 749140, 749174, 749208, 749243, 749277, 749311, 749345, 749379, 749413, 749448, 749482,
    749516, 749550, 749584, 749618, 749652, 749686, 749720, 749754, 749788, 749822, 749856, 749890,
    749924, 749958, 749992, 750026, 750060, 750094, 750128, 750162, 750196, 750229, 750263, 750297,
    750331, 750365, 750399, 750432, 750466, 750500, 750534, 750567, 750601, 750635, 750668, 750702,
    750736, 750769, 750803, 750837, 750870, 750904, 750938, 750971, 751005, 751038, 751072, 751105,
    751139, 751173, 751206, 751240, 751273, 751307, 751340, 751373, 751407, 751440, 751474, 751507,
    751540, 751574, 751607, 751641, 751674, 751707, 751741, 751774, 751807, 751840, 751874, 751907,
    751940, 751974, 752007, 752040, 752073, 752106, 752140, 752173, 752206, 752239, 752272, 752305,
    752338, 752371, 752405, 752438, 752471, 752504, 752537, 752570, 752603, 752636, 752669, 752702,
    752735, 752768, 752801, 752834, 752867, 752899, 752932, 752965, 752998, 753031, 753064, 753097,
    753130, 753162, 753195, 753228, 753261, 753294, 753326, 753359, 753392, 753425, 753457, 753490,
    753523, 753555, 753588, 753621, 753653, 753686, 753719, 753751, 753784, 753816, 753849, 753882,
    753914, 753947, 753979, 754012, 754044, 754077, 754109, 754142, 754174, 754207, 754239, 754272,
    754304, 754337, 754369, 754401, 754434, 754466, 754498, 754531, 754563, 754595, 754628, 754660,
    754692, 754725, 754757, 754789, 754821, 754854, 754886, 754918, 754950, 754983, 755015, 755047,
    755079, 755111, 755143, 755176, 755208, 755240, 755272, 755304, 755336, 755368, 755400, 755432,
    755464, 755496, 755528, 755560, 755592, 755624, 755656, 755688, 755720, 755752, 755784, 755816,
    755848, 755880, 755912, 755943, 755975, 756007, 756039, 756071, 756103, 756134, 756166, 756198,
    756230, 756262, 756293, 756325, 756357, 756389, 756420, 756452, 756484, 756515, 756547, 756579,
    756610, 756642, 756674, 756705, 756737, 756768, 756800, 756832, 756863, 756895, 756926, 756958,
    756989, 757021, 757052, 757084, 757115, 757147, 757178, 757210, 757241, 757272, 757304, 757335,
    757367, 757398, 757429, 757461, 757492, 757524, 757555, 757586, 757617, 757649, 757680, 757711,
    757743, 757774, 757805, 757836, 757868, 757899, 757930, 757961, 757992, 758024, 758055, 758086,
    758117, 758148, 758179, 758210, 758242, 758273, 758304, 758335, 758366, 758397, 758428, 758459,
    758490, 758521, 758552, 758583, 758614, 758645, 758676, 758707, 758738, 758769, 758800, 758831,
    758862, 758892, 758923, 758954, 758985, 759016, 759047, 759078, 759108, 759139, 759170, 759201,
    759232, 759262, 759293, 759324, 759355, 759385, 759416, 759447, 759478, 759508, 759539, 759570,
    759600, 759631, 759662, 759692, 759723, 759753, 759784, 759815, 759845, 759876, 759906, 759937,
    759967, 759998, 760028, 760059, 760089, 760120, 760150, 760181, 760211, 760242, 760272, 760303,
    760333, 760364, 760394, 760424, 760455, 760485, 760516, 760546, 760576, 760607, 760637, 760667,
    760697, 760728, 760758, 760788, 760819, 760849, 760879, 760909, 760940, 760970, 761000, 761030,
    761060, 761091, 761121, 761151, 761181, 761211, 761241, 761272, 761302, 761332, 761362, 761392,
    761422, 761452, 761482, 761512, 761542, 761572, 761602, 761632, 761662, 761692, 761722, 761752,
    761782, 761812, 761842, 761872, 761902, 761932, 761962, 761992, 762022, 762051, 762081, 762111,
    762141, 762171, 762201, 762231, 762260, 762290, 762320, 762350, 762379, 762409, 762439, 762469,
    762498, 762528, 762558, 762588, 762617, 762647, 762677, 762706, 762736, 762766, 762795, 762825,
    762855, 762884, 762914, 762943, 762973, 763003, 763032, 763062, 763091, 763121, 763150, 763180,
    763209, 763239, 763268, 763298, 763327, 763357, 763386, 763416, 763445, 763475, 763504, 763533,
    763563, 763592, 763622, 763651, 763680, 763710, 763739, 763768, 763798, 763827, 763856, 763886,
    763915, 763944, 763974, 764003, 764032, 764061, 764091, 764120, 764149, 764178, 764207, 764237,
    764266, 764295, 764324, 764353, 764382, 764412, 764441, 764470, 764499, 764528, 764557, 764586,
    764615, 764644, 764673, 764703, 764732, 764761, 764790, 764819, 764848, 764877, 764906, 764935,
    764964, 764993, 765021, 765050, 765079, 765108, 765137, 765166, 765195, 765224, 765253, 765282,
    765311, 765339, 765368, 765397, 765426, 765455, 765484, 765512, 765541, 765570, 765599, 765627,
    765656, 765685, 765714, 765742, 765771, 765800, 765829, 765857, 765886, 765915, 765943, 765972,
    766001, 766029, 766058, 766087, 766115, 766144, 766172, 766201, 766230, 766258, 766287, 766315,
    766344, 766372, 766401, 766429, 766458, 766486, 766515, 766543, 766572, 766600, 766629, 766657,
    766686, 766714, 766743, 766771, 766800, 766828, 766856, 766885, 766913, 766941, 766970, 766998,
    767027, 767055, 767083, 767112, 767140, 767168, 767196, 767225, 767253, 767281, 767310, 767338,
    767366, 767394, 767422, 767451, 767479, 767507, 767535, 767563, 767592, 767620, 767648, 767676,
    767704, 767732, 767761, 767789, 767817, 767845, 767873, 767901, 767929, 767957, 767985, 768013,
    768041, 768069, 768097, 768125, 768153, 768181, 768209, 768237, 768265, 768293, 768321, 768349,
    768377, 768405, 768433, 768461, 768489, 768517, 768545, 768573, 768600, 768628, 768656, 768684,
    768712, 768740, 768768, 768795, 768823, 768851, 768879, 768907, 768934, 768962, 768990, 769018,
    769045, 769073, 769101, 769129, 769156, 769184, 769212, 769239, 769267, 769295, 769322, 769350,
    769378, 769405, 769433, 769461, 769488, 769516, 769543, 769571, 769599, 769626, 769654, 769681,
    769709, 769736, 769764, 769792, 769819, 769847, 769874, 769902, 769929, 769957, 769984, 770011,
    770039, 770066, 770094, 770121, 770149, 770176, 770204, 770231, 770258, 770286, 770313, 770340,
    770368, 770395, 770423, 770450, 770477, 770504, 770532, 770559, 770586, 770614, 770641, 770668,
    770696, 770723, 770750, 770777, 770805, 770832, 770859, 770886, 770913, 770941, 770968, 770995,
    771022, 771049, 771076, 771104, 771131, 771158, 771185, 771212, 771239, 771266, 771293, 771321,
    771348, 771375, 771402, 771429, 771456, 771483, 771510, 771537, 771564, 771591, 771618, 771645,
    771672, 771699, 771726, 771753, 771780, 771807, 771834, 771861, 771888, 771914, 771941, 771968,
    771995, 772022, 772049, 772076, 772103, 772130, 772156, 772183, 772210, 772237, 772264, 772291,
    772317, 772344, 772371, 772398, 772424, 772451, 772478, 772505, 772531, 772558, 772585, 772612,
    772638, 772665, 772692, 772718, 772745, 772772, 772798, 772825, 772852, 772878, 772905, 772932,
    772958, 772985, 773012, 773038, 773065, 773091, 773118, 773144, 773171, 773198, 773224, 773251,
    773277, 773304, 773330, 773357, 773383, 773410, 773436, 773463, 773489, 773516, 773542, 773569,
    773595, 773621, 773648, 773674, 773701, 773727, 773754, 773780, 773806, 773833, 773859, 773885,
    773912, 773938, 773964, 773991, 774017, 774043, 774070, 774096, 774122, 774149, 774175, 774201,
    774227, 774254, 774280, 774306, 774332, 774359, 774385, 774411, 774437, 774464, 774490, 774516,
    774542, 774568, 774594, 774621, 774647, 774673, 774699, 774725, 774751, 774777, 774804, 774830,
    774856, 774882, 774908, 774934, 774960, 774986, 775012, 775038, 775064, 775090, 775116, 775142,
    775168, 775194, 775220, 775246, 775272, 775298, 775324, 775350, 775376, 775402, 775428, 775454,
    775480, 775506, 775532, 775558, 775583, 775609, 775635, 775661, 775687, 775713, 775739, 775764,
    775790, 775816, 775842, 775868, 775894, 775919, 775945, 775971, 775997, 776022, 776048, 776074,
    776100, 776126, 776151, 776177, 776203, 776228, 776254, 776280, 776306, 776331, 776357, 776383,
    776408, 776434, 776460, 776485, 776511, 776536, 776562, 776588, 776613, 776639, 776665, 776690,
    776716, 776741, 776767, 776792, 776818, 776844, 776869, 776895, 776920, 776946, 776971, 776997,
    777022, 777048, 777073, 777099, 777124, 777150, 777175, 777201, 777226, 777251, 777277, 777302,
    777328, 777353, 777379, 777404, 777429, 777455, 777480, 777505, 777531, 777556, 777582, 777607,
    777632, 777658, 777683, 777708, 777733, 777759, 777784, 777809, 777835, 777860, 777885, 777910,
    777936, 777961, 777986, 778011, 778037, 778062, 778087, 778112, 778138, 778163, 778188, 778213,
    778238, 778263, 778289, 778314, 778339, 778364, 778389, 778414, 778439, 778465, 778490, 778515,
    778540, 778565, 778590, 778615, 778640, 778665, 778690, 778715, 778740, 778765, 778790, 778815,
    778840, 778866, 778891, 778916, 778940, 778965, 778990, 779015, 779040, 779065, 779090, 779115,
    779140, 779165, 779190, 779215, 779240, 779265, 779290, 779315, 779339, 779364, 779389, 779414,
    779439, 779464, 779489, 779513, 779538, 779563, 779588, 779613, 779638, 779662, 779687, 779712,
    779737, 779761, 779786, 779811, 779836, 779861, 779885, 779910, 779935, 779959, 779984, 780009,
    780034, 780058, 780083, 780108, 780132, 780157, 780182, 780206, 780231, 780256, 780280, 780305,
    780329, 780354, 780379, 780403, 780428, 780453, 780477, 780502, 780526, 780551, 780575, 780600,
    780624, 780649, 780674, 780698, 780723, 780747, 780772, 780796, 780821, 780845, 780870, 780894,
    780919, 780943, 780967, 780992, 781016, 781041, 781065, 781090, 781114, 781139, 781163, 781187,
    781212, 781236, 781261, 781285, 781309, 781334, 781358, 781382, 781407, 781431, 781455, 781480,
    781504, 781528, 781553, 781577, 781601, 781626, 781650, 781674, 781698, 781723, 781747, 781771,
    781795, 781820, 781844, 781868, 781892, 781917, 781941, 781965, 781989, 782013, 782038, 782062,
    782086, 782110, 782134, 782158, 782182, 782207, 782231, 782255, 782279, 782303, 782327, 782351,
    782375, 782400, 782424, 782448, 782472, 782496, 782520, 782544, 782568, 782592, 782616, 782640,
    782664, 782688, 782712, 782736, 782760, 782784, 782808, 782832, 782856, 782880, 782904, 782928,
    782952, 782976, 783000, 783024, 783048, 783072, 783096, 783119, 783143, 783167, 783191, 783215,
    783239, 783263, 783287, 783310, 783334, 783358, 783382, 783406, 783430, 783454, 783477, 783501,
    783525, 783549, 783573, 783596, 783620, 783644, 783668, 783691, 783715, 783739, 783763, 783786,
    783810, 783834, 783858, 783881, 783905, 783929, 783952, 783976, 784000, 784024, 784047, 784071,
    784095, 784118, 784142, 784165, 784189, 784213, 784236, 784260, 784284, 784307, 784331, 784354,
    784378, 784402, 784425, 784449, 784472, 784496, 784519, 784543, 784567, 784590, 784614, 784637,
    784661, 784684, 784708, 784731, 784755, 784778, 784802, 784825, 784849, 784872, 784896, 784919,
    784943, 784966, 784989, 785013, 785036, 785060, 785083, 785107, 785130, 785153, 785177, 785200,
    785223, 785247, 785270, 785294, 785317, 785340, 785364, 785387, 785410, 785434, 785457, 785480,
    785504, 785527, 785550, 785574, 785597, 785620, 785643, 785667, 785690, 785713, 785736, 785760,
    785783, 785806, 785829, 785853, 785876, 785899, 785922, 785946, 785969, 785992, 786015, 786038,
    786061, 786085, 786108, 786131, 786154, 786177, 786200, 786224, 786247, 786270, 786293, 786316,
    786339, 786362, 786385, 786408
};

static const unsigned int bsc_delta_table[4096] =
{
         0, 131072, 180544, 212672, 236557, 255603, 271426, 284990, 296832, 307354, 316837, 325441,
    333328, 340596, 347363, 353689, 359571, 365165, 370408, 375372, 380114, 384632, 388922, 393032,
    396955, 400773, 404384, 407880, 411276, 414522, 417708, 420742, 423677, 426537, 429346, 432056,
    434646, 437242, 439712, 442104, 444512, 446788, 449065, 451271, 453414, 455502, 457543, 459593,
    461517, 463465, 465398, 467220, 468984, 470856, 472577, 474255, 476008, 477616, 479252, 480864,
    482456, 484032, 485533, 487023, 488441, 489985, 491399, 492747, 494236, 495528, 496899, 498285,
    499544, 500820, 502117, 503439, 504636, 505860, 507036, 508244, 509488, 510608, 511766, 512882,
    514041, 515161, 516242, 517372, 518377, 519523, 520454, 521622, 522574, 523584, 524656, 525602,
    526515, 527591, 528541, 529461, 530452, 531416, 532250, 533262, 534040, 535000, 535936, 536848,
    537627, 538599, 539328, 540254, 541159, 541929, 542790, 543514, 544448, 545128, 546022, 546778,
    547634, 548350, 549168, 549968, 550625, 551513, 552132, 552986, 553567, 554387, 555192, 555850,
    556490, 557380, 557988, 558578, 559424, 560120, 560662, 561466, 562117, 562753, 563517, 564125,
    564718, 565442, 566007, 566705, 567391, 567915, 568726, 569224, 569860, 570484, 571096, 571696,
    572284, 572860, 573583, 573977, 574678, 575370, 575890, 576398, 577059, 577545, 578186, 578650,
    579440, 579714, 580486, 580908, 581491, 582065, 582630, 583186, 583556, 584270, 584799, 585319,
    585649, 586331, 586824, 587492, 587784, 588436, 588895, 589345, 589975, 590409, 590834, 591442,
    591851, 592251, 592837, 593417, 593794, 594360, 594721, 595273, 595819, 596157, 596689, 597215,
    597530, 598042, 598548, 599048, 599333, 599819, 600299, 600773, 601241, 601703, 602159, 602609,
    603053, 603273, 603922, 604348, 604547, 605181, 605589, 605991, 606387, 607003, 607162, 607768,
    608142, 608510, 608872, 609228, 609811, 610157, 610497, 610831, 611396, 611720, 612277, 612351,
    613139, 613201, 613740, 614032, 614563, 614845, 615368, 615640, 615906, 616416, 616923, 617175,
    617421, 617915, 618151, 618893, 618864, 619342, 619817, 620029, 620496, 620960, 621158, 621614,
    621802, 622250, 622695, 623137, 623307, 623741, 623901, 624327, 624750, 625170, 625587, 625725,
    626134, 626262, 626942, 627062, 627457, 627849, 628238, 628340, 629006, 629100, 629475, 629847,
    629927, 630581, 630653, 631303, 631367, 631719, 632068, 632414, 632757, 633097, 633434, 633468,
    634098, 634426, 634448, 635072, 635086, 635706, 635712, 636328, 636326, 636938, 636928, 637536,
    637518, 638122, 638096, 638696, 638979, 639259, 639217, 639809, 640080, 640348, 640936, 640876,
    641135, 641717, 641645, 642223, 642472, 642718, 642961, 643201, 643438, 644006, 644239, 644133,
    644695, 645257, 645141, 645359, 645915, 646129, 646340, 646548, 647098, 646956, 647502, 647700,
    648244, 648088, 648628, 648816, 649001, 649183, 649717, 649895, 650070, 650600, 650771, 650939,
    651104, 651266, 651788, 651946, 652466, 652254, 652770, 653286, 653064, 653576, 653717, 654227,
    654364, 654498, 654629, 655133, 655260, 655762, 655506, 656384, 656122, 656618, 656731, 657225,
    657334, 657440, 657543, 658031, 658519, 658227, 659102, 658804, 659286, 659374, 659854, 659938,
    660019, 660495, 660971, 660647, 661119, 661591, 661660, 661726, 662194, 662256, 662722, 662780,
    662835, 663297, 663348, 663808, 663855, 664313, 664356, 664812, 664851, 664887, 665339, 665371,
    665821, 665849, 666297, 666321, 666767, 666787, 667231, 667247, 667689, 667701, 668141, 668149,
    668154, 669024, 668592, 669026, 669460, 669456, 669888, 669880, 669869, 670297, 670725, 670709,
    671135, 671115, 671539, 671515, 671937, 671909, 672329, 672749, 672716, 672680, 673096, 673512,
    673471, 673885, 673840, 674252, 674203, 674613, 674560, 674968, 675376, 675318, 675257, 676129,
    676066, 676000, 676402, 676332, 676732, 677132, 677057, 677455, 677853, 677773, 677690, 678084,
    678478, 678872, 678783, 678691, 679081, 679471, 679374, 679762, 680150, 680048, 680434, 680328,
    680712, 681096, 680985, 681367, 681252, 681632, 682012, 681892, 682270, 682648, 682523, 682899,
    682770, 683144, 683518, 683384, 683756, 683618, 684499, 684359, 684216, 684584, 684952, 684804,
    685170, 685536, 685383, 685747, 686111, 685953, 686315, 686677, 686514, 686874, 687234, 687066,
    687424, 687252, 688139, 687433, 688320, 688142, 688496, 688850, 688667, 689019, 688832, 689722,
    689533, 689341, 690232, 689494, 690385, 690187, 690533, 690879, 691225, 691021, 690814, 691708,
    691499, 691841, 691628, 691968, 692308, 692648, 692429, 692767, 693105, 692881, 693217, 693553,
    693889, 693659, 693993, 693759, 694660, 694424, 694185, 695087, 694846, 695176, 694931, 695835,
    695588, 695338, 696243, 695991, 696317, 696061, 696968, 696710, 697034, 696772, 697094, 697416,
    697738, 697470, 697790, 698110, 698430, 698156, 698474, 698792, 698513, 699427, 699146, 698862,
    699777, 699491, 699805, 700119, 699828, 700140, 700452, 700764, 700467, 700777, 701087, 701397,
    701094, 701402, 701710, 702018, 701709, 702015, 702321, 702627, 702312, 702616, 702920, 703224,
    702903, 703205, 703507, 703809, 703482, 703782, 704082, 704382, 704682, 704348, 704646, 704944,
    704605, 704901, 705836, 704854, 705789, 705443, 706380, 705388, 706325, 706619, 706266, 706558,
    706850, 706492, 707433, 707073, 707363, 706999, 707942, 707576, 707864, 708152, 707781, 708727,
    708354, 708640, 708926, 708548, 708832, 709116, 709400, 709684, 709299, 710251, 709864, 709474,
    710427, 710035, 710990, 710596, 710199, 711155, 710756, 711034, 711312, 711590, 711868, 711462,
    711738, 712014, 712290, 711878, 712841, 712427, 712701, 712283, 713248, 712828, 713100, 713372,
    713644, 713916, 713489, 713759, 714029, 714299, 713866, 714838, 714403, 714671, 714939, 714499,
    715474, 715032, 715298, 715564, 715830, 715382, 716361, 715911, 716175, 716439, 715984, 716966,
    716509, 716771, 717033, 716571, 717556, 717092, 717352, 717612, 717872, 718132, 717661, 717919,
    718177, 718435, 718693, 718951, 718472, 718728, 718984, 719240, 719496, 719010, 720007, 719519,
    719773, 720027, 719534, 720534, 720039, 720291, 720543, 720795, 721047, 720545, 720795, 721801,
    721296, 720788, 721795, 722045, 721534, 721782, 722030, 722278, 722526, 722008, 722254, 723268,
    722747, 722993, 722468, 723484, 722957, 723201, 723445, 723689, 723933, 724177, 723642, 723884,
    724907, 724369, 723828, 724852, 725094, 724550, 724790, 725030, 725270, 725510, 725750, 725198,
    725436, 725674, 725912, 726150, 726388, 726626, 726065, 726301, 726537, 726773, 727009, 727245,
    726676, 727716, 727145, 727379, 727613, 727847, 727270, 728314, 727735, 728781, 728200, 728432,
    727847, 728895, 729127, 728539, 728769, 728999, 729229, 729459, 729689, 729093, 730148, 729550,
    729778, 730006, 730234, 730462, 729857, 730917, 730310, 730536, 730762, 730988, 731214, 730600,
    731665, 731049, 731273, 731497, 731721, 731945, 732169, 731545, 732616, 731990, 732212, 732434,
    732656, 732878, 733100, 732466, 733543, 732907, 733127, 733347, 733567, 733787, 733144, 734226,
    733581, 733799, 734884, 734236, 733585, 734671, 734889, 734235, 735324, 734668, 734884, 735100,
    735316, 735532, 734869, 735963, 735298, 735512, 735726, 735940, 736154, 736368, 736582, 735908,
    737009, 736333, 736545, 736757, 736969, 737181, 737393, 736709, 737816, 737130, 737340, 737550,
    737760, 737970, 738180, 738390, 737695, 738809, 738112, 738320, 738528, 738736, 738944, 739152,
    738447, 739567, 738860, 739982, 739273, 739479, 739685, 739891, 739176, 740302, 739585, 740713,
    739994, 740198, 740402, 740606, 740810, 741014, 740287, 741421, 740692, 740894, 742031, 741299,
    741501, 741703, 740966, 742106, 741367, 742509, 741768, 741968, 742168, 742368, 742568, 742768,
    742968, 742218, 743367, 742615, 743766, 743012, 743210, 743408, 743606, 742846, 744001, 743239,
    744396, 743632, 743828, 744988, 744221, 744417, 743646, 744808, 745004, 744230, 745395, 744619,
    744813, 745007, 745201, 745395, 745589, 745783, 744998, 746170, 745383, 746557, 745768, 745960,
    746152, 746344, 746536, 746728, 745931, 747111, 746312, 747494, 746693, 746883, 747073, 747263,
    747453, 747643, 747833, 747023, 748212, 747400, 747588, 748780, 747965, 748153, 748341, 748529,
    747708, 748904, 748081, 749279, 748454, 749654, 748827, 749013, 749199, 749385, 749571, 748737,
    749942, 750128, 749291, 750499, 749660, 749844, 750028, 750212, 750396, 750580, 750764, 749916,
    751131, 750281, 751498, 750646, 750828, 751010, 751192, 751374, 751556, 751738, 751920, 751058,
    752283, 751419, 752646, 751780, 751960, 752140, 752320, 752500, 752680, 752860, 751985, 753219,
    752342, 753578, 752699, 752877, 754116, 753234, 753412, 752526, 753767, 753945, 754123, 753233,
    754478, 753586, 753762, 755010, 754115, 754291, 754467, 754643, 754819, 753917, 755170, 755346,
    754441, 755697, 754790, 754964, 755138, 756398, 755487, 754573, 755834, 756008, 756182, 755264,
    756529, 755609, 756876, 755954, 756126, 757396, 756471, 756643, 755714, 756986, 757158, 757330,
    756397, 757673, 756738, 758016, 757079, 757249, 757419, 757589, 757759, 757929, 758099, 758269,
    758439, 757491, 758778, 757828, 759117, 758165, 758333, 758501, 758669, 758837, 759005, 759173,
    759341, 759509, 758546, 759844, 758879, 760179, 759212, 759378, 760681, 759711, 759877, 760043,
    760209, 759233, 760540, 760706, 759727, 761037, 760056, 761368, 760385, 760549, 761864, 760878,
    761042, 761206, 761370, 760378, 761697, 761861, 760866, 762188, 761191, 762515, 761516, 761678,
    763005, 762003, 762165, 762327, 762489, 762651, 761642, 762974, 763136, 762124, 763459, 762445,
    763782, 762766, 762926, 763086, 763246, 763406, 763566, 763726, 763886, 764046, 763019, 764365,
    764525, 763495, 764844, 763812, 763970, 764128, 765481, 764445, 764603, 764761, 764919, 763877,
    765234, 765392, 764347, 765707, 764660, 766022, 764973, 766337, 765286, 765442, 765598, 765754,
    765910, 766066, 766222, 766378, 765317, 766689, 766845, 765781, 767156, 766090, 766244, 767622,
    766553, 766707, 766861, 767015, 767169, 767323, 767477, 767631, 766552, 767938, 768092, 767010,
    768399, 767315, 767467, 768859, 767772, 767924, 768076, 768228, 768380, 768532, 768684, 768836,
    767739, 769139, 769291, 768191, 769594, 768492, 768642, 770048, 768943, 769093, 769243, 769393,
    769543, 769693, 769843, 769993, 770143, 770293, 769176, 770592, 769473, 770891, 769770, 771190,
    770067, 770215, 770363, 770511, 771936, 770808, 769677, 771103, 771251, 771399, 771547, 770411,
    771842, 771990, 770851, 770997, 772432, 771290, 771436, 772874, 771729, 771875, 772021, 772167,
    772313, 772459, 772605, 771451, 772896, 773042, 771885, 773333, 772174, 773624, 772463, 772607,
    774060, 772896, 773040, 773184, 773328, 773472, 773616, 773760, 773904, 772730, 774191, 774335,
    773158, 774622, 773443, 774909, 773728, 775196, 774013, 774155, 774297, 774439, 774581, 774723,
    774865, 775007, 775149, 775291, 775433, 774237, 775716, 775858, 774659, 776141, 774940, 775080,
    776565, 775361, 775501, 775641, 777130, 775922, 776062, 776202, 774989, 776481, 776621, 776761,
    776901, 775683, 777180, 775960, 777459, 776237, 777738, 776514, 776652, 778156, 776929, 777067,
    777205, 777343, 777481, 777619, 777757, 777895, 776658, 778170, 778308, 778446, 777205, 778721,
    777478, 778996, 777751, 777887, 779408, 778160, 778296, 778432, 778568, 778704, 778840, 778976,
    779112, 779248, 779384, 779520, 778259, 779791, 779927, 778663, 780198, 778932, 779066, 780604,
    779335, 779469, 781010, 779738, 779872, 780006, 780140, 780274, 780408, 780542, 780676, 779394,
    780943, 781077, 781211, 779925, 781478, 780190, 781745, 780455, 782012, 780720, 780852, 780984,
    782545, 781249, 781381, 781513, 781645, 781777, 781909, 782041, 780736, 782304, 782436, 782568,
    781259, 782831, 781520, 783094, 781781, 783357, 782042, 782172, 783751, 782433, 782563, 782693,
    782823, 782953, 783083, 783213, 783343, 783473, 783603, 783733, 782402, 783992, 784122, 782788,
    784381, 783045, 784640, 783302, 784899, 783559, 783687, 785287, 783944, 784072, 784200, 784328,
    784456, 784584, 784712, 784840, 784968, 785096, 785224, 783868, 785479, 785607, 784248, 785862,
    784501, 786117, 784754, 786372, 785007, 785133, 786754, 785386, 785512, 785638, 785764, 785890,
    786016, 786142, 786268, 786394, 786520, 786646, 785265, 786897, 787023, 785639, 787274, 787400,
    786013, 787651, 786262, 786386, 788027, 786635, 786759, 788403, 787008, 787132, 787256, 787380,
    787504, 787628, 787752, 787876, 788000, 788124, 786717, 788371, 788495, 787085, 788742, 788866,
    787453, 789113, 787698, 789360, 787943, 788065, 789730, 788310, 788432, 788554, 788676, 788798,
    788920, 789042, 789164, 789286, 789408, 789530, 789652, 789774, 789896, 788460, 790139, 788701,
    790382, 790504, 789063, 790747, 789304, 789424, 791111, 789665, 789785, 791475, 790026, 790146,
    790266, 790386, 790506, 790626, 790746, 790866, 790986, 791106, 791226, 791346, 789883, 791585,
    791705, 790239, 791944, 790476, 792183, 790713, 792422, 790950, 792661, 791187, 791305, 793019,
    791542, 791660, 791778, 791896, 792014, 792132, 792250, 792368, 792486, 792604, 792722, 792840,
    792958, 791466, 793193, 793311, 791816, 793546, 793664, 792166, 793899, 792399, 792515, 794251,
    792748, 792864, 794603, 793097, 793213, 793329, 793445, 795189, 793678, 793794, 793910, 794026,
    792509, 794257, 794373, 794489, 794605, 794721, 793198, 794952, 795068, 793542, 795299, 793771,
    795530, 794000, 795761, 794229, 794343, 796107, 794572, 794686, 794800, 796568, 795029, 795143,
    795257, 795371, 795485, 795599, 795713, 795827, 795941, 796055, 794504, 796282, 796396, 796510,
    794955, 796737, 795180, 796964, 797078, 795518, 795630, 797418, 795855, 797645, 796080, 796192,
    797985, 796417, 796529, 796641, 796753, 796865, 796977, 797089, 797201, 797313, 797425, 797537,
    797649, 797761, 797873, 796289, 798096, 798208, 798320, 796732, 798543, 796953, 798766, 797174,
    798989, 797395, 799212, 797616, 797726, 799546, 797947, 798057, 798167, 799991, 798388, 798498,
    798608, 798718, 798828, 798938, 799048, 799158, 799268, 799378, 799488, 797872, 799707, 799817,
    799927, 798307, 800146, 798524, 800365, 800475, 798850, 800694, 799067, 799175, 801022, 799392,
    799500, 801350, 799717, 799825, 799933, 801787, 800150, 800258, 800366, 800474, 800582, 800690,
    800798, 800906, 801014, 801122, 799473, 801337, 801445, 801553, 799900, 801768, 801876, 800220,
    802091, 800433, 802306, 800646, 802521, 800859, 802736, 801072, 801178, 803058, 801391, 801497,
    803380, 801710, 801816, 801922, 802028, 802134, 802240, 802346, 802452, 802558, 802664, 802770,
    802876, 802982, 803088, 801402, 803299, 803405, 801716, 803616, 803722, 802030, 803933, 802239,
    804144, 802448, 804355, 802657, 804566, 802866, 802970, 804882, 803179, 803283, 805198, 803492,
    803596, 803700, 803804, 803908, 804012, 804116, 804220, 804324, 804428, 804532, 804636, 804740,
    804844, 803122, 805051, 805155, 805259, 803533, 805466, 805570, 803841, 805777, 804046, 805984,
    804251, 806191, 804456, 806398, 804661, 804763, 806708, 804968, 805070, 805172, 807121, 805377,
    805479, 805581, 805683, 805785, 805887, 805989, 806091, 806193, 806295, 806397, 806499, 806601,
    806703, 804943, 806906, 807008, 807110, 805346, 807313, 805547, 807516, 807618, 805849, 807821,
    806050, 808024, 806251, 808227, 806452, 806552, 808531, 806753, 806853, 806953, 808936, 807154,
    807254, 807354, 807454, 807554, 807654, 807754, 809745, 806063, 808054, 808154, 808254, 808354,
    808454, 808554, 808654, 806854, 808853, 808953, 809053, 807249, 809252, 809352, 807545, 809551,
    807742, 809750, 807939, 809949, 808136, 810148, 808333, 808431, 810446, 808628, 808726, 808824,
    810843, 809021, 809119, 809217, 809315, 809413, 811438, 809610, 809708, 809806, 809904, 810002,
    808167, 810197, 810295, 810393, 810491, 810589, 810687, 808845, 810882, 810980, 809135, 811175,
    811273, 809425, 811468, 809618, 811663, 809811, 811858, 810004, 812053, 810197, 812248, 810390,
    810486, 810582, 812637, 810775, 810871, 810967, 813026, 811160, 811256, 811352, 811448, 811544,
    811640, 811736, 811832, 811928, 812024, 812120, 812216, 812312, 812408, 810526, 812599, 812695,
    812791, 810905, 812982, 813078, 811189, 813269, 813365, 811473, 813556, 811662, 813747, 811851,
    813938, 812040, 812134, 814224, 812323, 814415, 812512, 812606, 812700, 814796, 812889, 812983,
    813077, 813171, 813265, 815367, 813454, 813548, 813642, 813736, 813830, 813924, 814018, 814112,
    812189, 814299, 814393, 814487, 814581, 812653, 814768, 814862, 814956, 813024, 815143, 815237,
    813302, 815424, 813487, 815611, 813672, 815798, 813857, 815985, 814042, 816172, 814227, 814319,
    816452, 814504, 814596, 816732, 814781, 814873, 814965, 817105, 815150, 815242, 815334, 815426,
    815518, 815610, 815702, 815794, 815886, 815978, 816070, 816162, 816254, 816346, 814375, 816529,
    816621, 816713, 816805, 814829, 816988, 817080, 815101, 817263, 817355, 815373, 817538, 815554,
    817721, 815735, 817904, 815916, 818087, 816097, 818270, 816278, 816368, 818544, 816549, 816639,
    818818, 816820, 816910, 817000, 817090, 819274, 817271, 817361, 817451, 817541, 817631, 817721,
    817811, 817901, 817991, 818081, 818171, 818261, 818351, 818441, 818531, 816511, 818710, 818800,
    818890, 816866, 819069, 819159, 817132, 819338, 819428, 817398, 819607, 819697, 817664, 819876,
    817841, 820055, 818018, 818106, 820323, 818283, 820502, 818460, 818548, 820770, 818725, 818813,
    821038, 818990, 819078, 819166, 819254, 819342, 821573, 819519, 819607, 819695, 819783, 819871,
    819959, 820047, 820135, 820223, 820311, 820399, 820487, 818419, 820662, 820750, 820838, 820926,
    818853, 821101, 821189, 821277, 819200, 821452, 821540, 819460, 821715, 819633, 821890, 821978,
    819893, 822153, 820066, 820152, 822415, 820325, 822590, 820498, 820584, 822852, 820757, 820843,
    823114, 821016, 821102, 821188, 823463, 821361, 821447, 821533, 821619, 821705, 821791, 824073,
    821964, 822050, 822136, 822222, 822308, 820192, 822479, 822565, 822651, 822737, 822823, 822909,
    822995, 820871, 823166, 823252, 823338, 821210, 823509, 823595, 821464, 823766, 823852, 821718,
    824023, 821887, 824194, 822056, 824365, 822225, 824536, 822394, 824707, 822563, 824878, 822732,
    822816, 825134, 822985, 823069, 823153, 825475, 823322, 823406, 823490, 825816, 823659, 823743,
    823827, 823911, 823995, 824079, 824163, 824247, 824331, 824415, 824499, 824583, 824667, 824751,
    824835, 824919, 825003, 825087, 822910, 825254, 825338, 825422, 825506, 823324, 825673, 825757,
    823572, 825924, 826008, 823820, 826175, 826259, 824068, 826426, 824233, 826593, 824398, 826760,
    824563, 826927, 824728, 824810, 827177, 824975, 825057, 827427, 825222, 825304, 827677, 825469,
    825551, 825633, 828010, 825798, 825880, 825962, 826044, 826126, 828509, 826291, 826373, 826455,
    826537, 826619, 826701, 826783, 826865, 826947, 827029, 824799, 827192, 827274, 827356, 827438,
    827520, 825284, 827683, 827765, 827847, 825607, 828010, 828092, 828174, 825930, 828337, 826091,
    828500, 828582, 826333, 828745, 826494, 828908, 826655, 829071, 826816, 829234, 826977, 829397,
    827138, 827218, 829641, 827379, 827459, 829885, 827620, 827700, 830129, 827861, 827941, 828021,
    828101, 830535, 828262, 828342, 828422, 828502, 828582, 828662, 828742, 828822, 828902, 828982,
    829062, 829142, 829222, 829302, 829382, 829462, 829542, 829622, 829702, 827408, 829861, 829941,
    830021, 830101, 827802, 830260, 830340, 830420, 828117, 830579, 830659, 828353, 830818, 828510,
    830977, 831057, 828746, 831216, 828903, 831375, 829060, 831534, 829217, 831693, 829374, 829452,
    831931, 829609, 829687, 832169, 829844, 829922, 832407, 830079, 830157, 830235, 832724, 830392,
    830470, 830548, 830626, 833120, 830783, 830861, 830939, 831017, 831095, 831173, 831251, 831329,
    831407, 831485, 831563, 831641, 831719, 831797, 831875, 831953, 832031, 829675, 832186, 832264,
    832342, 832420, 830059, 832575, 832653, 832731, 830366, 832886, 832964, 830596, 833119, 833197,
    830826, 833352, 830979, 833507, 833585, 831209, 833740, 831362, 833895, 831515, 834050, 831668,
    831744, 834282, 831897, 834437, 832050, 832126, 834669, 832279, 832355, 834901, 832508, 832584,
    832660, 835210, 832813, 832889, 832965, 833041, 833117, 835673, 833270, 833346, 833422, 833498,
    833574, 833650, 833726, 833802, 833878, 833954, 834030, 834106, 834182, 834258, 834334, 834410,
    831989, 834561, 834637, 834713, 834789, 834865, 832438, 835016, 835092, 835168, 832737, 835319,
    835395, 832961, 835546, 835622, 833185, 835773, 835849, 833409, 836000, 833558, 836151, 833707,
    836302, 833856, 836453, 834005, 836604, 834154, 836755, 834303, 834377, 836981, 834526, 837132,
    834675, 834749, 837358, 834898, 834972, 835046, 837659, 835195, 835269, 835343, 835417, 838035,
    835566, 835640, 835714, 835788, 835862, 835936, 836010, 836084, 836158, 838786, 836307, 836381,
    836455, 833971, 836602, 836676, 836750, 836824, 836898, 836972, 837046, 837120, 837194, 834700,
    837341, 837415, 837489, 837563, 835064, 837710, 837784, 835282, 837931, 838005, 838079, 835573,
    838226, 835718, 838373, 838447, 835936, 838594, 836081, 838741, 836226, 838888, 836371, 839035,
    836516, 839182, 836661, 839329, 836806, 839476, 836951, 837023, 839696, 837168, 837240, 839916,
    837385, 837457, 837529, 840209, 837674, 837746, 837818, 840502, 837963, 838035, 838107, 838179,
    838251, 840941, 838396, 838468, 838540, 838612, 838684, 838756, 838828, 838900, 838972, 839044,
    839116, 839188, 839260, 839332, 839404, 839476, 839548, 836984, 839691, 839763, 839835, 839907,
    839979, 837409, 840122, 840194, 840266, 837692, 840409, 840481, 840553, 837975, 840696, 840768,
    838187, 840911, 838328, 841054, 841126, 838540, 841269, 838681, 841412, 838822, 841555, 838963,
    841698, 839104, 841841, 839245, 841984, 839386, 842127, 839527, 839597, 842341, 839738, 839808,
    842555, 839949, 840019, 842769, 840160, 840230, 840300, 843054, 840441, 840511, 840581, 840651,
    843410, 840792, 840862, 840932, 841002, 841072, 841142, 841212, 841282, 844050, 841423, 841493,
    841563, 841633, 841703, 841773, 839138, 841912, 841982, 842052, 842122, 842192, 842262, 842332,
    842402, 842472, 839827, 842611, 842681, 842751, 842821, 840171, 842960, 843030, 843100, 840446,
    843239, 843309, 840652, 843448, 843518, 840858, 843657, 843727, 841064, 843866, 841201, 844005,
    841338, 844144, 841475, 844283, 844353, 841681, 841749, 844561, 841886, 844700, 842023, 844839,
    842160, 842228, 845047, 842365, 845186, 842502, 842570, 845394, 842707, 842775, 842843, 845671,
    842980, 843048, 843116, 845948, 843253, 843321, 843389, 843457, 843525, 846363, 843662, 843730,
    843798, 843866, 843934, 844002, 844070, 844138, 844206, 844274, 844342, 844410, 844478, 844546,
    844614, 844682, 844750, 844818, 844886, 844954, 845022, 845090, 842365, 845225, 845293, 845361,
    845429, 845497, 842766, 845632, 845700, 845768, 843033, 845903, 845971, 843233, 846106, 846174,
    843433, 846309, 846377, 843633, 846512, 846580, 843833, 846715, 843966, 846850, 844099, 846985,
    847053, 844299, 847188, 844432, 847323, 844565, 844631, 847525, 844764, 847660, 844897, 844963,
    847862, 845096, 847997, 845229, 845295, 848199, 845428, 845494, 845560, 848468, 845693, 845759,
    848670, 845892, 845958, 846024, 846090, 849006, 846223, 846289, 846355, 846421, 846487, 846553,
    846619, 849543, 846752, 846818, 846884, 846950, 847016, 847082, 847148, 847214, 847280, 847346,
    847412, 847478, 847544, 847610, 844803, 847741, 847807, 847873, 847939, 848005, 848071, 848137,
    845322, 848268, 848334, 848400, 848466, 845646, 848597, 848663, 848729, 845905, 848860, 848926,
    846099, 849057, 849123, 846293, 849254, 849320, 846487, 849451, 846616, 849582, 849648, 846810,
    849779, 846939, 849910, 847068, 850041, 847197, 850172, 847326, 850303, 847455, 850434, 847584,
    850565, 847713, 847777, 850761, 847906, 847970, 850957, 848099, 848163, 851153, 848292, 848356,
    851349, 848485, 848549, 848613, 851610, 848742, 848806, 848870, 851871, 848999, 849063, 849127,
    849191, 849255, 852262, 849384, 849448, 849512, 849576, 849640, 849704, 849768, 849832, 849896,
    849960, 850024, 850088, 850152, 850216, 850280, 850344, 850408, 850472, 850536, 850600, 850664,
    850728, 850792, 847889, 850919, 850983, 851047, 851111, 851175, 848266, 851302, 851366, 851430,
    851494, 848580, 851621, 851685, 851749, 848831, 851876, 851940, 849019, 852067, 852131, 849207,
    852258, 852322, 849395, 852449, 849520, 852576, 852640, 849708, 852767, 849833, 852894, 849958,
    853021, 850083, 853148, 850208, 853275, 850333, 853402, 850458, 850520, 853592, 850645, 853719,
    850770, 850832, 853909, 850957, 854036, 851082, 851144, 851206, 854289, 851331, 851393, 854479,
    851518, 851580, 851642, 854732, 851767, 851829, 851891, 851953, 855048, 852078, 852140, 852202,
    852264, 852326, 852388, 855490, 852513, 852575, 852637, 852699, 852761, 852823, 852885, 852947,
    853009, 853071, 853133, 853195, 853257, 853319, 853381, 853443, 853505, 853567, 853629, 853691,
    850692, 853814, 853876, 853938, 854000, 854062, 854124, 851118, 854247, 854309, 854371, 854433,
    851422, 854556, 854618, 854680, 851665, 854803, 854865, 854927, 851908, 855050, 855112, 852090,
    855235, 855297, 852272, 855420, 852393, 855543, 855605, 852575, 855728, 852696, 855851, 852817,
    855974, 852938, 856097, 853059, 856220, 853180, 856343, 853301, 856466, 853422, 856589, 853543,
    856712, 853664, 853724, 856896, 853845, 857019, 853966, 854026, 857203, 854147, 854207, 854267,
    857448, 854388, 854448, 857632, 854569, 854629, 854689, 857877, 854810, 854870, 854930, 854990,
    858183, 855111, 855171, 855231, 855291, 855351, 858550, 855472, 855532, 855592, 855652, 855712,
    855772, 855832, 855892, 855952, 856012, 856072, 856132, 856192, 856252, 856312, 856372, 856432,
    856492, 856552, 856612, 856672, 856732, 856792, 856852, 856912, 853807, 857031, 857091, 857151,
    857211, 857271, 857331, 854219, 857450, 857510, 857570, 854454, 857689, 857749, 857809, 854689,
    857928, 857988, 858048, 854924, 858167, 858227, 855100, 858346, 858406, 855276, 858525, 858585,
    855452, 858704, 855569, 858823, 858883, 855745, 859002, 855862, 859121, 855979, 859240, 856096,
    859359, 856213, 859478, 856330, 859597, 856447, 859716, 856564, 859835, 856681, 856739, 860013,
    856856, 860132, 856973, 857031, 860310, 857148, 857206, 860488, 857323, 857381, 860666, 857498,
    857556, 860844, 857673, 857731, 857789, 861081, 857906, 857964, 858022, 858080, 861377, 858197,
    858255, 858313, 858371, 858429, 861732, 858546, 858604, 858662, 858720, 858778, 858836, 858894,
    858952, 859010, 862323, 859127, 859185, 859243, 859301, 859359, 859417, 859475, 859533, 859591,
    859649, 856441, 859764, 859822, 859880, 859938, 859996, 860054, 860112, 860170, 860228, 860286,
    857067, 860401, 860459, 860517, 860575, 860633, 857408, 860748, 860806, 860864, 857635, 860979,
    861037, 861095, 857862, 861210, 861268, 861326, 858089, 861441, 861499, 858259, 861614, 861672,
    858429, 861787, 861845, 858599, 861960, 858712, 862075, 862133, 858882, 862248, 858995, 862363,
    859108, 862478, 859221, 862593, 859334, 862708, 859447, 862823, 859560, 862938, 859673, 863053,
    859786, 863168, 859899, 863283, 860012, 860068, 863455, 860181, 860237, 863627, 860350, 863742,
    860463, 860519, 863914, 860632, 860688, 860744, 864143, 860857, 860913, 864315, 861026, 861082,
    861138, 861194, 864601, 861307, 861363, 861419, 861475, 864887, 861588, 861644, 861700, 861756,
    861812, 865230, 861925, 861981, 862037, 862093, 862149, 862205, 862261, 862317, 862373, 862429,
    862485, 862541, 862597, 862653, 862709, 862765, 862821, 862877, 862933, 862989, 863045, 863101,
    863157, 863213, 863269, 863325, 863381, 863437, 863493, 860157, 863604, 863660, 863716, 863772,
    863828, 863884, 860541, 863995, 864051, 864107, 864163, 860815, 864274, 864330, 864386, 861034,
    864497, 864553, 864609, 861253, 864720, 864776, 861417, 864887, 864943, 861581, 865054, 865110,
    861745, 865221, 865277, 861909, 865388, 862018, 865499, 865555, 862182, 865666, 862291, 865777,
    862400, 865888, 865944, 862564, 866055, 862673, 866166, 862782, 866277, 862891, 862945, 866443,
    863054, 866554, 863163, 866665, 863272, 866776, 863381, 863435, 866942, 863544, 863598, 867108,
    863707, 867219, 863816, 863870, 863924, 867440, 864033, 864087, 867606, 864196, 864250, 867772,
    864359, 864413, 864467, 867993, 864576, 864630, 864684, 864738, 868269, 864847, 864901, 864955,
    865009, 865063, 868600, 865172, 865226, 865280, 865334, 865388, 865442, 865496, 869041, 865605,
    865659, 865713, 865767, 865821, 865875, 865929, 865983, 866037, 866091, 866145, 866199, 866253,
    866307, 866361, 866415, 866469, 866523, 866577, 866631, 866685, 863226, 866792, 866846, 866900,
    866954, 867008, 867062, 867116, 867170, 863702, 867277, 867331, 867385, 867439, 867493, 864019,
    867600, 867654, 867708, 864230, 867815, 867869, 867923, 864441, 868030, 868084, 868138, 864652,
    868245, 868299, 864810, 868406, 868460, 864968, 868567, 868621, 865126, 868728, 868782, 865284,
    868889, 868943, 865442, 869050, 865547, 869157, 865652, 869264, 869318, 865810, 869425, 865915,
    869532, 866020, 869639, 866125, 869746, 866230, 869853, 866335, 869960, 866440, 870067, 866545,
    866597, 870227, 866702, 870334, 866807, 870441, 866912, 866964, 870601, 867069, 867121, 870761,
    867226, 867278, 870921, 867383, 867435, 871081, 867540, 867592, 871241, 867697, 867749, 867801,
    871454, 867906, 867958, 868010, 871667, 868115, 868167, 868219, 871880, 868324, 868376, 868428,
    868480, 868532, 872199, 868637, 868689, 868741, 868793, 868845, 868897, 872571, 869002, 869054,
    869106, 869158, 869210, 869262, 869314, 869366, 869418, 869470, 869522, 869574, 869626, 869678,
    869730, 869782, 869834, 869886, 869938, 869990, 870042, 870094, 870146, 870198, 870250, 870302,
    870354, 870406, 870458, 866858, 870561, 870613, 870665, 870717, 870769, 870821, 867214, 870924,
    870976, 871028, 871080, 871132, 867519, 871235, 871287, 871339, 867722, 871442, 871494, 871546,
    871598, 867976, 871701, 871753, 868128, 871856, 871908, 871960, 868331, 872063, 872115, 868483,
    872218, 872270, 868635, 872373, 868736, 872476, 872528, 868888, 872631, 872683, 869040, 872786,
    869141, 872889, 869242, 872992, 873044, 869394, 873147, 869495, 873250, 869596, 873353, 869697,
    873456, 869798, 873559, 869899, 873662, 870000, 873765, 870101, 870151, 873919, 870252, 874022,
    870353, 874125, 870454, 870504, 874279, 870605, 870655, 874433, 870756, 874536, 870857, 870907,
    874690, 871008, 871058, 871108, 874895, 871209, 871259, 875049, 871360, 871410, 871460, 875254,
    871561, 871611, 871661, 875459, 871762, 871812, 871862, 875664, 871963, 872013, 872063, 872113,
    872163, 875971, 872264, 872314, 872364, 872414, 872464, 872514, 876329, 872615, 872665, 872715,
    872765, 872815, 872865, 872915, 872965, 873015, 873065, 873115, 873165, 873215, 873265, 873315,
    877146, 873416, 873466, 869732, 873565, 873615, 873665, 873715, 873765, 873815, 873865, 873915,
    873965, 874015, 874065, 874115, 874165, 874215, 874265, 870515, 874364, 874414, 874464, 874514,
    874564, 874614, 870857, 874713, 874763, 874813, 874863, 874913, 871150, 875012, 875062, 875112,
    871345, 875211, 875261, 875311, 875361, 871589, 875460, 875510, 871735, 875609, 875659, 875709,
    871930, 875808, 875858, 872076, 875957, 876007, 872222, 876106, 876156, 872368, 876255, 872465,
    876354, 876404, 872611, 876503, 876553, 872757, 876652, 872854, 876751, 872951, 876850, 873048,
    876949, 876999, 873194, 877098, 873291, 877197, 873388, 877296, 873485, 877395, 873582, 877494,
    873679, 873727, 877642, 873824, 877741, 873921, 877840, 874018, 877939, 874115, 874163, 878087,
    874260, 878186, 874357, 874405, 878334, 874502, 874550, 878482, 874647, 874695, 878630, 874792,
    874840, 878778, 874937, 874985, 878926, 875082, 875130, 875178, 879123, 875275, 875323, 875371,
    879320, 875468, 875516, 875564, 879517, 875661, 875709, 875757, 875805, 879763, 875902, 875950,
    875998, 876046, 876094, 876142, 880107, 876239, 876287, 876335, 876383, 876431, 876479, 876527,
    880500, 876624, 876672, 876720, 876768, 876816, 876864, 876912, 876960, 877008, 877056, 877104,
    877152, 877200, 877248, 877296, 877344, 877392, 877440, 877488, 877536, 877584, 877632, 877680,
    877728, 877776, 877824, 877872, 877920, 877968, 874061, 878063, 878111, 878159, 878207, 878255,
    878303, 878351, 874436, 878446, 878494, 878542, 878590, 878638, 878686, 874764, 878781, 878829,
    878877, 878925, 874998, 879020, 879068, 879116, 875185, 879211, 879259, 879307, 875372, 879402,
    879450, 879498, 875559, 879593, 879641, 875699, 879736, 879784, 879832, 875886, 879927, 879975,
    876026, 880070, 876119, 880165, 880213, 876259, 880308, 880356, 876399, 880451, 876492, 880546,
    880594, 876632, 880689, 876725, 880784, 876818, 880879, 880927, 876958, 881022, 877051, 881117,
    877144, 881212, 877237, 881307, 877330, 881402, 877423, 881497, 877516, 881592, 877609, 881687,
    877702, 877748, 881829, 877841, 881924, 877934, 882019, 878027, 878073, 882161, 878166, 878212,
    882303, 878305, 882398, 878398, 878444, 882540, 878537, 878583, 882682, 878676, 878722, 882824,
    878815, 878861, 882966, 878954, 879000, 879046, 883155, 879139, 879185, 879231, 883344, 879324,
    879370, 879416, 883533, 879509, 879555, 879601, 883722, 879694, 879740, 879786, 879832, 879878,
    884005, 879971, 880017, 880063, 880109, 880155, 884288, 880248, 880294, 880340, 880386, 880432,
    880478, 880524, 880570, 884712
};

static INLINE long long bsc_entropy(int n)
{
    if (n < 0x1000)     return (long long) n * bsc_code_table[n];
    if (n < 0x100000)   return (long long) n * (8  * 65536 + bsc_code_table[n >>  8]);
    if (n < 0x10000000) return (long long) n * (16 * 65536 + bsc_code_table[n >> 16]);
    return (long long) n * (20 * 65536 + bsc_code_table[n >> 20]);
};

static INLINE long long bsc_delta(int n)
{
    if (n < 0x1000) return (long long) bsc_delta_table[n];
    if ((n & 0xff) != 0xff)
    {
        if (n < 0x100000)   return (long long)(bsc_code_table[n >>  8] +  8 * 65536);
        if (n < 0x10000000) return (long long)(bsc_code_table[n >> 16] + 16 * 65536);
        return (long long)(bsc_code_table[n >> 20] + 20 * 65536);
    }
    return bsc_entropy(n + 1) - bsc_entropy(n);
};

#endif

/*-----------------------------------------------------------*/
/* End                                              tables.h */
/*-----------------------------------------------------------*/
